/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.portal.kernel.lock.BaseLockListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;

public class DLFileEntryLockListener
extends BaseLockListener {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryLockListener.class);

    public String getClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public void onAfterExpire(String key) {
        long fileEntryId = GetterUtil.getLong((String)key);
        try {
            if (PropsValues.DL_FILE_ENTRY_LOCK_POLICY == 1) {
                DLFileEntryServiceUtil.checkInFileEntry((long)fileEntryId, (boolean)true, (String)"Automatic timeout checkin", (ServiceContext)new ServiceContext());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Lock expired and checked in " + fileEntryId));
                }
            } else {
                DLFileEntryServiceUtil.cancelCheckOut((long)fileEntryId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Lock expired and canceled check out of " + fileEntryId));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

