/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDExportsCheck
extends BaseFileCheck {
    private final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkExports(fileName, content, this._exportContentsPattern, "-exportcontents");
            this._checkExports(fileName, content, this._exportsPattern, "Export-Package");
        }
        return content;
    }

    private void _checkExports(String fileName, String content, Pattern pattern, String definitionKey) {
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null || bundleSymbolicName.endsWith(".compat")) {
            return;
        }
        Matcher matcher = this._apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        bundleSymbolicName = matcher.replaceAll("");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String[] lines = StringUtil.splitLines(matcher.group(2));
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtil.removeChar(StringUtil.trim(lines[i]), '\\');
            if (Validator.isNull(line) || !line.startsWith("com.liferay.") || line.startsWith(bundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append(definitionKey);
            sb.append(" '");
            sb.append(line);
            sb.append("' should match Bundle-SymbolicName '");
            sb.append(bundleSymbolicName);
            sb.append("'");
            this.addMessage(fileName, sb.toString(), this.getLineCount(content, matcher.start(2)) + i);
        }
    }
}

