/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependenciesCheck
extends BaseFileCheck {
    private final Pattern _dependenciesPattern = Pattern.compile("^dependencies \\{(.+?\n)\\}", 40);
    private final Pattern _incorrectWhitespacePattern = Pattern.compile(":[^ \n]");
    private String _projectPathPrefix;

    @Override
    public void init() throws Exception {
        this._projectPathPrefix = this.getProjectPathPrefix();
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatDependencies(absolutePath, content);
    }

    private String _formatDependencies(String absolutePath, String content) {
        Matcher matcher = this._dependenciesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String dependencies = matcher.group(1);
        matcher = this._incorrectWhitespacePattern.matcher(dependencies);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(dependencies, matcher.start())) continue;
            String newDependencies = StringUtil.insert(dependencies, " ", matcher.end() - 1);
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        if (dependencies.contains("'")) {
            String newDependencies = StringUtil.replace(dependencies, '\'', '\"');
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        TreeSet<String> uniqueDependencies = new TreeSet<String>(new GradleDependencyComparator());
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            uniqueDependencies.add(dependency);
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            String configuration = this._getConfiguration(dependency);
            if (configuration.equals("compile") && this.isModulesApp(absolutePath, this._projectPathPrefix, false)) {
                dependency = StringUtil.replaceFirst(dependency, "compile", "provided");
            }
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
            }
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }

    private String _getConfiguration(String dependency) {
        int pos = dependency.indexOf(" ");
        return dependency.substring(0, pos);
    }

    private class GradleDependencyComparator
    implements Comparator<String>,
    Serializable {
        private GradleDependencyComparator() {
        }

        @Override
        public int compare(String dependency1, String dependency2) {
            String configuration2;
            String configuration1 = GradleDependenciesCheck.this._getConfiguration(dependency1);
            if (!configuration1.equals(configuration2 = GradleDependenciesCheck.this._getConfiguration(dependency2))) {
                return dependency1.compareTo(dependency2);
            }
            String group1 = this._getPropertyValue(dependency1, "group");
            String group2 = this._getPropertyValue(dependency2, "group");
            if (group1 != null && group1.equals(group2)) {
                String name1 = this._getPropertyValue(dependency1, "name");
                String name2 = this._getPropertyValue(dependency2, "name");
                if (name1 != null && name1.equals(name2)) {
                    return 0;
                }
            }
            return dependency1.compareTo(dependency2);
        }

        private String _getPropertyValue(String dependency, String propertyName) {
            Pattern pattern = Pattern.compile(".* " + propertyName + ": \"(.+?)\"");
            Matcher matcher = pattern.matcher(dependency);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

