/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)<[\\w/].*[^-]>(\n\n)(\t*)<(\\w)");
    private final Pattern _missingEmptyLineAfterCommentPattern = Pattern.compile("[\t ]-->\n[\t<]");
    private final Pattern _missingEmptyLineBeforeCommentPattern = Pattern.compile(">\n\t+<!--[\n ]");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.matches(".*\\.(action|function|macro|testcase)") || fileName.startsWith(this.getBaseDirName() + "build") || fileName.matches(".*/(build|tools/).*") || fileName.endsWith("/content.xml")) {
            return content;
        }
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this._fixEmptyLinesBetweenTags(fileName, content);
        content = this._fixMissingEmptyLinesAroundComments(content);
        return content;
    }

    private String _fixEmptyLinesBetweenTags(String fileName, String content) {
        if (fileName.endsWith("-log4j.xml") || fileName.endsWith("-logback.xml") || fileName.endsWith("/ivy.xml") || fileName.endsWith("/struts-config.xml") || fileName.endsWith("/tiles-defs.xml")) {
            return this.fixEmptyLinesBetweenTags(content);
        }
        Matcher matcher = this._emptyLineBetweenTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
        }
        return content;
    }

    private String _fixMissingEmptyLinesAroundComments(String content) {
        Matcher matcher = this._missingEmptyLineAfterCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "-->\n", "-->\n\n", matcher.start());
        }
        matcher = this._missingEmptyLineBeforeCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, ">\n", ">\n\n", matcher.start());
        }
        return content;
    }
}

