/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChainingCheck
extends AbstractCheck {
    private static final String _MSG_AVOID_CHAINING = "chaining.avoid";
    private static final String _MSG_AVOID_CHAINING_MULTIPLE = "chaining.avoid.multiple";
    private static final String _MSG_AVOID_TOO_MANY_CONCAT = "concat.avoid.too.many";
    private static final String _MSG_INCORRECT_STYLING = "styling.incorrect";
    private String[] _allowedClassNames = new String[0];
    private String[] _allowedMethodNames = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void setAllowedClassNames(String allowedClassNames) {
        this._allowedClassNames = StringUtil.split(allowedClassNames);
    }

    public void setAllowedMethodNames(String allowedMethodNames) {
        this._allowedMethodNames = StringUtil.split(allowedMethodNames);
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (fileName.contains("/test/")) {
            return;
        }
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            List<String> chainedMethodNames;
            List<DetailAST> childMethodCallASTList;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST != null && !(childMethodCallASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 27)).isEmpty() || (chainedMethodNames = this._getChainedMethodNames(methodCallAST)).size() == 1) continue;
            if (this._isAllowedChainingMethodCall(detailAST, methodCallAST, chainedMethodNames)) {
                this._checkStyling(methodCallAST);
                continue;
            }
            this._checkMethodName(chainedMethodNames, "getClass", methodCallAST, detailAST);
            if (chainedMethodNames.size() == 2) continue;
            int concatsCount = Collections.frequency(chainedMethodNames, "concat");
            if (concatsCount > 2) {
                this.log(methodCallAST.getLineNo(), _MSG_AVOID_TOO_MANY_CONCAT, new Object[0]);
                continue;
            }
            if (chainedMethodNames.size() == 3 && concatsCount == 2) continue;
            this.log(methodCallAST.getLineNo(), _MSG_AVOID_CHAINING_MULTIPLE, new Object[]{DetailASTUtil.getMethodName(methodCallAST)});
        }
    }

    private void _checkMethodName(List<String> chainedMethodNames, String methodName, DetailAST methodCallAST, DetailAST detailAST) {
        String firstMethodName = chainedMethodNames.get(0);
        if (firstMethodName.equals(methodName) && !this._isInsideConstructorThisCall(methodCallAST, detailAST)) {
            this.log(methodCallAST.getLineNo(), _MSG_AVOID_CHAINING, new Object[]{methodName});
        }
    }

    private void _checkStyling(DetailAST methodCallAST) {
        FileContents fileContents = this.getFileContents();
        for (int i = DetailASTUtil.getStartLine(methodCallAST) + 1; i <= DetailASTUtil.getEndLine(methodCallAST); ++i) {
            String line = StringUtil.trim(fileContents.getLine(i - 1));
            if (!line.startsWith(").")) continue;
            return;
        }
        this.log(methodCallAST.getLineNo(), _MSG_INCORRECT_STYLING, new Object[]{DetailASTUtil.getMethodName(methodCallAST)});
    }

    private List<String> _getChainedMethodNames(DetailAST methodCallAST) {
        ArrayList<String> chainedMethodNames = new ArrayList<String>();
        chainedMethodNames.add(DetailASTUtil.getMethodName(methodCallAST));
        DetailAST parentAST;
        while ((parentAST = methodCallAST.getParent()).getType() == 59) {
            methodCallAST = parentAST.getParent();
            if (methodCallAST.getType() != 27) {
                return chainedMethodNames;
            }
            chainedMethodNames.add(DetailASTUtil.getMethodName(methodCallAST));
        }
        return chainedMethodNames;
    }

    private DetailAST _getClassAST(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getParent() != null) {
            return parentAST.getParent();
        }
        return null;
    }

    private String _getVariableType(DetailAST detailAST, String variableName) {
        List<Object> definitionASTList = new ArrayList();
        if (variableName.matches("_[a-z].*")) {
            definitionASTList = DetailASTUtil.getAllChildTokens(this._getClassAST(detailAST), true, 21, 10);
        } else if (variableName.matches("[a-z].*")) {
            definitionASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 21, 10);
        }
        for (DetailAST definitionAST : definitionASTList) {
            String name;
            DetailAST nameAST = definitionAST.findFirstToken(58);
            if (nameAST == null || !(name = nameAST.getText()).equals(variableName)) continue;
            DetailAST typeAST = definitionAST.findFirstToken(13);
            nameAST = typeAST.findFirstToken(58);
            if (nameAST == null) {
                return null;
            }
            return nameAST.getText();
        }
        return null;
    }

    private boolean _isAllowedChainingMethodCall(DetailAST detailAST, DetailAST methodCallAST, List<String> chainedMethodNames) {
        for (String allowedMethodName : this._allowedMethodNames) {
            if (!chainedMethodNames.contains(allowedMethodName)) continue;
            return true;
        }
        DetailAST dotAST = methodCallAST.findFirstToken(59);
        if (dotAST == null) {
            return false;
        }
        DetailAST nameAST = dotAST.findFirstToken(58);
        String classOrVariableName = nameAST.getText();
        if (classOrVariableName.matches(".*[Bb]uilder")) {
            return true;
        }
        String variableType = this._getVariableType(detailAST, classOrVariableName);
        if (variableType != null) {
            for (String allowedClassName : this._allowedClassNames) {
                if (!variableType.matches(allowedClassName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isInsideConstructorThisCall(DetailAST methodCallAST, DetailAST detailAST) {
        if (detailAST.getType() != 8) {
            return false;
        }
        for (DetailAST parentAST = methodCallAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            String parentASTText = parentAST.getText();
            if (parentAST.getType() != 43 || !parentASTText.equals("this")) continue;
            return true;
        }
        return false;
    }
}

