/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.ThreadSafeClassLibrary;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistenceCallCheck
extends AbstractCheck {
    private static final String _MSG_ILLEGAL_PERSISTENCE_CALL = "persistence.call.illegal";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST parent = detailAST.getParent();
        if (parent != null) {
            return;
        }
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (!fileName.contains("/modules/")) {
            return;
        }
        FileText fileText = fileContents.getText();
        String content = (String)fileText.getFullText();
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder((DocletTagFactory)new DefaultDocletTagFactory(), (ClassLibrary)new ThreadSafeClassLibrary());
        try {
            javaDocBuilder.addSource((Reader)new UnsyncStringReader(content));
        }
        catch (ParseException pe) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(javaDocBuilder, fileName);
        javaDocBuilder = this._addExtendedClassSource(javaDocBuilder, javaClass, fileName);
        List<String> importNames = this._getImportNames(detailAST);
        Map<String, String> variablesMap = this._getVariablesMap(javaDocBuilder);
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkMethodCall(methodCallAST, importNames, variablesMap, javaClass.getPackageName());
        }
    }

    private JavaDocBuilder _addExtendedClassSource(JavaDocBuilder javaDocBuilder, JavaClass javaClass, String fileName) {
        Type superClassType = javaClass.getSuperClass();
        String fullyQualifiedName = superClassType.getFullyQualifiedName();
        if (!fullyQualifiedName.startsWith("com.liferay")) {
            return javaDocBuilder;
        }
        int pos = fileName.lastIndexOf("/com/liferay/");
        String extendedClassFileName = fileName.substring(0, pos + 1) + StringUtil.replace(fullyQualifiedName, '.', '/') + ".java";
        try {
            javaDocBuilder.addSource(new File(extendedClassFileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaDocBuilder;
    }

    private void _checkClass(String className, List<String> importNames, String packageName, int lineNo) {
        for (String importName : importNames) {
            if (!importName.endsWith("." + className)) continue;
            int pos = importName.indexOf(".service.persistence.");
            if (pos == -1) {
                return;
            }
            if (packageName.startsWith(importName.substring(0, pos))) continue;
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{importName});
        }
    }

    private void _checkMethodCall(DetailAST methodCallAST, List<String> importNames, Map<String, String> variablesMap, String packageName) {
        String methodName;
        DetailAST childAST = methodCallAST.getFirstChild();
        if (childAST.getType() != 59) {
            return;
        }
        if ((childAST = childAST.getFirstChild()).getType() != 58) {
            return;
        }
        DetailAST siblingAST = childAST.getNextSibling();
        if (siblingAST.getType() == 58 && ((methodName = siblingAST.getText()).equals("clearCache") || methodName.startsWith("create"))) {
            return;
        }
        String fieldName = childAST.getText();
        if (fieldName.matches("[A-Z].*")) {
            this._checkClass(fieldName, importNames, packageName, methodCallAST.getLineNo());
        } else {
            this._checkVariable(fieldName, variablesMap, packageName, methodCallAST.getLineNo());
        }
    }

    private void _checkVariable(String variableName, Map<String, String> variablesMap, String packageName, int lineNo) {
        String fullyQualifiedTypeName = variablesMap.get(variableName);
        if (fullyQualifiedTypeName == null) {
            return;
        }
        int pos = fullyQualifiedTypeName.indexOf(".service.persistence.");
        if (pos == -1) {
            return;
        }
        if (!packageName.startsWith(fullyQualifiedTypeName.substring(0, pos))) {
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{fullyQualifiedTypeName});
        }
    }

    private List<String> _getImportNames(DetailAST detailAST) {
        ArrayList<String> importASTList = new ArrayList<String>();
        DetailAST sibling = detailAST.getPreviousSibling();
        while (sibling.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)sibling);
            importASTList.add(importIdent.getText());
            sibling = sibling.getPreviousSibling();
        }
        return importASTList;
    }

    private JavaClass _getJavaClass(JavaDocBuilder javaDocBuilder, String fileName) {
        int pos = fileName.lastIndexOf("/");
        String className = fileName.substring(pos + 1, fileName.length() - 5);
        for (JavaClass javaClass : javaDocBuilder.getClasses()) {
            if (!className.equals(javaClass.getName())) continue;
            return javaClass;
        }
        return null;
    }

    private Map<String, String> _getVariablesMap(JavaDocBuilder javaDocBuilder) {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (JavaClass javaClass : javaDocBuilder.getClasses()) {
            for (JavaField javaField : javaClass.getFields()) {
                String fieldName = javaField.getName();
                Type fieldType = javaField.getType();
                String fullyQualifiedTypeName = fieldType.getFullyQualifiedName();
                variablesMap.put(fieldName, fullyQualifiedTypeName);
            }
        }
        return variablesMap;
    }
}

