/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence.impl;

import com.liferay.counter.kernel.model.Counter;
import com.liferay.counter.kernel.service.persistence.CounterFinder;
import com.liferay.counter.model.CounterHolder;
import com.liferay.counter.model.CounterRegister;
import com.liferay.counter.model.impl.CounterImpl;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Dummy;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CounterFinderImpl
extends BasePersistenceImpl<Dummy>
implements CacheRegistryItem,
CounterFinder {
    private static final int _DEFAULT_CURRENT_ID = 0;
    private static final int _MINIMUM_INCREMENT_SIZE = 1;
    private static final String _NAME = Counter.class.getName();
    private static final String _SQL_INSERT = "insert into Counter(name, currentId) values (?, ?)";
    private static final String _SQL_SELECT_ID_BY_NAME = "select currentId from Counter where name = ?";
    private static final String _SQL_SELECT_NAMES = "select name from Counter order by name asc";
    private static final String _SQL_UPDATE_NAME_BY_NAME = "update Counter set name = ? where name = ?";
    private final Map<String, CounterRegister> _counterRegisterMap = new ConcurrentHashMap<String, CounterRegister>();
    private final Map<String, Integer> _rangeSizeMap = new ConcurrentHashMap<String, Integer>();

    public List<String> getNames() {
        ArrayList<String> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(_SQL_SELECT_NAMES);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (resultSet.next()) {
                list.add(resultSet.getString(1));
            }
            arrayList = list;
        }
        catch (SQLException sqle) {
            try {
                throw this.processException(sqle);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    public String getRegistryName() {
        return CounterFinderImpl.class.getName();
    }

    public long increment() {
        return this.increment(_NAME);
    }

    public long increment(String name) {
        return this.increment(name, 1);
    }

    public long increment(String name, int size) {
        if (size < 1) {
            size = 1;
        }
        CounterRegister counterRegister = this.getCounterRegister(name);
        return this._competeIncrement(counterRegister, size);
    }

    public void invalidate() {
        this._counterRegisterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rename(String oldName, String newName) {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(oldName);
        synchronized (counterRegister2) {
            if (this._counterRegisterMap.containsKey(newName)) {
                throw new SystemException("Cannot rename " + oldName + " to " + newName);
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(_SQL_UPDATE_NAME_BY_NAME);
                preparedStatement.setString(1, newName);
                preparedStatement.setString(2, oldName);
                preparedStatement.executeUpdate();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                DataAccess.cleanUp((Connection)connection, preparedStatement);
            }
            catch (Exception e) {
                throw this.processException(e);
                {
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)connection, preparedStatement);
                        throw throwable;
                    }
                }
            }
            DataAccess.cleanUp((Connection)connection, (Statement)preparedStatement);
            counterRegister.setName(newName);
            this._counterRegisterMap.put(newName, counterRegister);
            this._counterRegisterMap.remove(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String name) {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(name);
        synchronized (counterRegister2) {
            Session session = null;
            try {
                session = this.openSession();
                Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)name));
                session.delete((Object)counter);
                session.flush();
            }
            catch (ObjectNotFoundException counter) {
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
            this._counterRegisterMap.remove(name);
        }
    }

    public void reset(String name, long size) {
        CounterRegister counterRegister = this.createCounterRegister(name, size);
        this._counterRegisterMap.put(name, counterRegister);
    }

    protected CounterRegister createCounterRegister(String name) {
        return this.createCounterRegister(name, -1L);
    }

    protected CounterRegister createCounterRegister(String name, long size) {
        int rangeSize;
        block51: {
            long rangeMin = -1L;
            rangeSize = this.getRangeSize(name);
            try (Connection connection = this.getConnection();
                 PreparedStatement ps1 = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);){
                ps1.setString(1, name);
                try (ResultSet resultSet = ps1.executeQuery();){
                    if (resultSet.next()) break block51;
                    rangeMin = 0L;
                    if (size > rangeMin) {
                        rangeMin = size;
                    }
                    try (PreparedStatement ps2 = connection.prepareStatement(_SQL_INSERT);){
                        ps2.setString(1, name);
                        ps2.setLong(2, rangeMin);
                        ps2.executeUpdate();
                    }
                }
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        CounterHolder counterHolder = this._obtainIncrement(name, rangeSize, size);
        return new CounterRegister(name, counterHolder, rangeSize);
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CounterRegister getCounterRegister(String name) {
        CounterRegister counterRegister = this._counterRegisterMap.get(name);
        if (counterRegister != null) {
            return counterRegister;
        }
        Map<String, CounterRegister> map = this._counterRegisterMap;
        synchronized (map) {
            counterRegister = this._counterRegisterMap.get(name);
            if (counterRegister == null) {
                counterRegister = this.createCounterRegister(name);
                this._counterRegisterMap.put(name, counterRegister);
            }
            return counterRegister;
        }
    }

    protected int getRangeSize(String name) {
        if (name.equals(_NAME)) {
            return PropsValues.COUNTER_INCREMENT;
        }
        String incrementType = null;
        int pos = name.indexOf(35);
        incrementType = pos != -1 ? name.substring(0, pos) : name;
        Integer rangeSize = this._rangeSizeMap.get(incrementType);
        if (rangeSize == null) {
            rangeSize = GetterUtil.getInteger((String)PropsUtil.get("counter.increment." + incrementType), (int)PropsValues.COUNTER_INCREMENT);
            this._rangeSizeMap.put(incrementType, rangeSize);
        }
        return rangeSize;
    }

    private long _competeIncrement(CounterRegister counterRegister, int size) {
        CounterHolder counterHolder = counterRegister.getCounterHolder();
        long newValue = counterHolder.addAndGet(size);
        if (newValue <= counterHolder.getRangeMax()) {
            return newValue;
        }
        CompeteLatch competeLatch = counterRegister.getCompeteLatch();
        if (!competeLatch.compete()) {
            try {
                competeLatch.await();
            }
            catch (InterruptedException ie) {
                throw this.processException(ie);
            }
            return this._competeIncrement(counterRegister, size);
        }
        try {
            counterHolder = counterRegister.getCounterHolder();
            newValue = counterHolder.addAndGet(size);
            if (newValue > counterHolder.getRangeMax()) {
                CounterHolder newCounterHolder = this._obtainIncrement(counterRegister.getName(), counterRegister.getRangeSize(), 0L);
                newValue = newCounterHolder.addAndGet(size);
                counterRegister.setCounterHolder(newCounterHolder);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            competeLatch.done();
        }
        return newValue;
    }

    private CounterHolder _obtainIncrement(String counterName, long range, long size) {
        Session session = null;
        try {
            session = this.openSession();
            Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)counterName), LockMode.UPGRADE);
            long newValue = counter.getCurrentId();
            if (size > newValue) {
                newValue = size;
            }
            long rangeMax = newValue + range;
            counter.setCurrentId(rangeMax);
            CounterHolder counterHolder = new CounterHolder(newValue, rangeMax);
            session.saveOrUpdate((Object)counter);
            session.flush();
            CounterHolder counterHolder2 = counterHolder;
            return counterHolder2;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

