/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.SQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseSQLTransformerLogic
implements SQLTransformerLogic {
    private final DB _db;
    private Function[] _functions;

    public BaseSQLTransformerLogic(DB db) {
        this._db = db;
    }

    @Override
    public Function<String, String>[] getFunctions() {
        return this._functions;
    }

    protected Function<String, String> getBitwiseCheckFunction() {
        Pattern pattern = this.getBitwiseCheckPattern();
        return sql -> this.replaceBitwiseCheck(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getBitwiseCheckPattern() {
        return Pattern.compile("BITAND\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)");
    }

    protected Function<String, String> getBooleanFunction() {
        return sql -> StringUtil.replace((String)sql, (String[])new String[]{"[$FALSE$]", "[$TRUE$]"}, (String[])new String[]{this._db.getTemplateFalse(), this._db.getTemplateTrue()});
    }

    protected Function<String, String> getCastClobTextFunction() {
        Pattern pattern = this.getCastClobTextPattern();
        return sql -> this.replaceCastClobText(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getCastClobTextPattern() {
        return Pattern.compile("CAST_CLOB_TEXT\\((.+?)\\)", 2);
    }

    protected Function<String, String> getCastLongFunction() {
        Pattern pattern = this.getCastLongPattern();
        return sql -> this.replaceCastLong(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getCastLongPattern() {
        return Pattern.compile("CAST_LONG\\((.+?)\\)", 2);
    }

    protected Function<String, String> getCastTextFunction() {
        Pattern pattern = this.getCastTextPattern();
        return sql -> this.replaceCastText(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getCastTextPattern() {
        return Pattern.compile("CAST_TEXT\\((.+?)\\)", 2);
    }

    protected Function<String, String> getInstrFunction() {
        Pattern pattern = this.getInstrPattern();
        return sql -> this.replaceInstr(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getInstrPattern() {
        return Pattern.compile("INSTR\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)", 2);
    }

    protected Function<String, String> getIntegerDivisionFunction() {
        Pattern pattern = this.getIntegerDivisionPattern();
        return sql -> this.replaceIntegerDivision(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getIntegerDivisionPattern() {
        return Pattern.compile("INTEGER_DIV\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)", 2);
    }

    protected Function<String, String> getModFunction() {
        Pattern pattern = this.getModPattern();
        return sql -> this.replaceMod(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getModPattern() {
        return Pattern.compile("MOD\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)", 2);
    }

    protected Function<String, String> getNullDateFunction() {
        return sql -> StringUtil.replace((String)sql, (String)"[$NULL_DATE$]", (String)"NULL");
    }

    protected Function<String, String> getSubstrFunction() {
        Pattern pattern = this.getSubstrPattern();
        return sql -> this.replaceSubstr(pattern.matcher((CharSequence)sql));
    }

    protected Pattern getSubstrPattern() {
        return Pattern.compile("SUBSTR\\(\\s*(.+?)\\s*,\\s*(.+?)\\s*,\\s*(.+?)\\s*\\)", 2);
    }

    protected String replaceBitwiseCheck(Matcher matcher) {
        return matcher.replaceAll("($1 & $2)");
    }

    protected String replaceCastClobText(Matcher matcher) {
        return this.replaceCastText(matcher);
    }

    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("$1");
    }

    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("$1");
    }

    protected String replaceInstr(Matcher matcher) {
        return matcher.replaceAll("CHARINDEX($2, $1)");
    }

    protected String replaceIntegerDivision(Matcher matcher) {
        return matcher.replaceAll("$1 / $2");
    }

    protected String replaceMod(Matcher matcher) {
        return matcher.replaceAll("$1 % $2");
    }

    protected String replaceSubstr(Matcher matcher) {
        return matcher.replaceAll("SUBSTRING($1, $2, $3)");
    }

    protected void setFunctions(Function ... functions) {
        this._functions = functions;
    }
}

