/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.theme.ThemeLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeLoaderFactory {
    private static final Map<String, ThemeLoader> _themeLoaders = new HashMap<String, ThemeLoader>();

    public static boolean destroy(String servletContextName) {
        ThemeLoader themeLoader = _themeLoaders.remove(servletContextName);
        if (themeLoader == null) {
            return false;
        }
        ServletContextPool.remove((String)servletContextName);
        themeLoader.destroy();
        return true;
    }

    public static ThemeLoader getDefaultThemeLoader() {
        ThemeLoader themeLoader;
        block0: {
            themeLoader = null;
            Iterator<Map.Entry<String, ThemeLoader>> iterator = _themeLoaders.entrySet().iterator();
            if (!iterator.hasNext()) break block0;
            Map.Entry<String, ThemeLoader> entry = iterator.next();
            themeLoader = entry.getValue();
        }
        return themeLoader;
    }

    public static ThemeLoader getThemeLoader(String servletContextName) {
        return _themeLoaders.get(servletContextName);
    }

    public static void init(String servletContextName, ServletContext servletContext, String[] xmls) {
        ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        ThemeLoader themeLoader = new ThemeLoader(servletContextName, servletContext, xmls);
        _themeLoaders.put(servletContextName, themeLoader);
    }

    public static void loadThemes() {
        for (Map.Entry<String, ThemeLoader> entry : _themeLoaders.entrySet()) {
            ThemeLoader themeLoader = entry.getValue();
            themeLoader.loadThemes();
        }
    }
}

