/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static final String _GET_COMPANY_IDS = "select companyId from Company";
    private static final Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static final Set<String> _autoLoginIgnoreHosts;
    private static final Set<String> _autoLoginIgnorePaths;
    private static long[] _companyIds;
    private static final Set<String> _virtualHostsIgnoreHosts;
    private static final Set<String> _virtualHostsIgnorePaths;
    private static String[] _webIds;

    public static void addCompanyId(long companyId) {
        if (ArrayUtil.contains((long[])_companyIds, (long)companyId)) {
            return;
        }
        long[] companyIds = new long[_companyIds.length + 1];
        System.arraycopy(_companyIds, 0, companyIds, 0, _companyIds.length);
        companyIds[PortalInstances._companyIds.length] = companyId;
        _companyIds = companyIds;
    }

    public static long getCompanyId(HttpServletRequest request) {
        long cookieCompanyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        Long companyIdObj = (Long)request.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from request " + companyIdObj));
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        long companyId = PortalInstances._getCompanyIdByVirtualHosts(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company id from host " + companyId));
        }
        if (companyId <= 0L && (cookieCompanyId = GetterUtil.getLong((String)CookieKeys.getCookie((HttpServletRequest)request, (String)"COMPANY_ID", (boolean)false))) > 0L) {
            try {
                if (CompanyLocalServiceUtil.fetchCompanyById((long)cookieCompanyId) == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Company id from cookie " + cookieCompanyId + " does not exist"));
                    }
                } else {
                    companyId = cookieCompanyId;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Company id from cookie " + companyId));
                    }
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (companyId <= 0L) {
            companyId = PortalInstances.getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Default company id " + companyId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set company id " + companyId));
        }
        request.setAttribute("COMPANY_ID", (Object)companyId);
        CompanyThreadLocal.setCompanyId((Long)companyId);
        if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && request.getAttribute("VIRTUAL_HOST_LAYOUT_SET") == null) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                if (Validator.isNull((String)layoutSet.getVirtualHostname())) {
                    request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return companyId;
    }

    public static long[] getCompanyIds() {
        return _companyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_COMPANY_IDS);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                companyIds.add(companyId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[companyIds.size()]));
    }

    public static long getDefaultCompanyId() {
        return _companyIds[0];
    }

    public static String[] getWebIds() {
        if (_webIds != null) {
            return _webIds;
        }
        if (Validator.isNull((String)PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new RuntimeException("Default web id must not be null");
        }
        try {
            List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
            ArrayList<String> webIdsList = new ArrayList<String>(companies.size());
            for (Company company : companies) {
                String webId = company.getWebId();
                if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                    webIdsList.add(0, webId);
                    continue;
                }
                webIdsList.add(webId);
            }
            _webIds = webIdsList.toArray(new String[webIdsList.size()]);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (ArrayUtil.isEmpty((Object[])_webIds)) {
            _webIds = new String[]{PropsValues.COMPANY_DEFAULT_WEB_ID};
        }
        return _webIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long initCompany(ServletContext servletContext, String webId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Begin initializing company with web id " + webId));
        }
        long companyId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.checkCompany((String)webId);
            companyId = company.getCompanyId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        Long currentThreadCompanyId = CompanyThreadLocal.getCompanyId();
        String currentThreadPrincipalName = PrincipalThreadLocal.getName();
        try {
            User user;
            CompanyThreadLocal.setCompanyId((Long)companyId);
            String principalName = null;
            long userId = PrincipalThreadLocal.getUserId();
            if (userId > 0L && (user = UserLocalServiceUtil.fetchUser((long)userId)) != null && user.getCompanyId() == companyId) {
                principalName = currentThreadPrincipalName;
            }
            PrincipalThreadLocal.setName(principalName);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initialize display");
            }
            try {
                String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                if (portletCategory == null) {
                    portletCategory = new PortletCategory();
                }
                PortletCategory newPortletCategory = PortletLocalServiceUtil.getEARDisplay((String)xml);
                portletCategory.merge(newPortletCategory);
                for (int i = 0; i < _companyIds.length; ++i) {
                    long currentCompanyId = _companyIds[i];
                    PortletCategory currentPortletCategory = (PortletCategory)WebAppPool.get(currentCompanyId, "PORTLET_CATEGORY");
                    if (currentPortletCategory == null) continue;
                    portletCategory.merge(currentPortletCategory);
                }
                WebAppPool.put(companyId, "PORTLET_CATEGORY", portletCategory);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process application startup events");
            }
            try {
                EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(companyId)});
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("End initializing company with web id " + webId + " and company id " + companyId));
            }
            PortalInstances.addCompanyId(companyId);
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)currentThreadCompanyId);
            PrincipalThreadLocal.setName((String)currentThreadPrincipalName);
        }
        return companyId;
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _autoLoginIgnoreHosts.contains(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _autoLoginIgnorePaths.contains(path);
    }

    public static boolean isCompanyActive(long companyId) {
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company != null) {
                return company.isActive();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _virtualHostsIgnoreHosts.contains(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _virtualHostsIgnorePaths.contains(path);
    }

    public static void reload(ServletContext servletContext) {
        String[] webIds;
        _companyIds = new long[0];
        _webIds = null;
        for (String webId : webIds = PortalInstances.getWebIds()) {
            PortalInstances.initCompany(servletContext, webId);
        }
    }

    public static void removeCompany(long companyId) {
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        _companyIds = ArrayUtil.remove((long[])_companyIds, (long)companyId);
        _webIds = null;
        PortalInstances.getWebIds();
        WebAppPool.remove(companyId, "PORTLET_CATEGORY");
    }

    private static long _getCompanyIdByVirtualHosts(HttpServletRequest request) {
        String host = PortalUtil.getHost((HttpServletRequest)request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Host " + host));
        }
        if (Validator.isNull((String)host) || PortalInstances.isVirtualHostsIgnoreHost(host)) {
            return 0L;
        }
        try {
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
            if (virtualHost == null) {
                return 0L;
            }
            if (virtualHost.getLayoutSetId() != 0L) {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Company " + virtualHost.getCompanyId() + " is associated with layout set " + virtualHost.getLayoutSetId()));
                }
                request.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
            }
            return virtualHost.getCompanyId();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0L;
        }
    }

    private PortalInstances() {
    }

    static {
        _companyIds = new long[0];
        _autoLoginIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.hosts"));
        _autoLoginIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.paths"));
        _virtualHostsIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.hosts"));
        _virtualHostsIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.paths"));
    }
}

