/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class AssetTagPermission {
    public static void check(PermissionChecker permissionChecker, AssetTag tag, String actionId) throws PortalException {
        if (!AssetTagPermission.contains(permissionChecker, tag, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetTag.class.getName(), tag.getTagId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long tagId, String actionId) throws PortalException {
        if (!AssetTagPermission.contains(permissionChecker, tagId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AssetTag.class.getName(), tagId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetTag tag, String actionId) {
        if (permissionChecker.hasOwnerPermission(tag.getCompanyId(), AssetTag.class.getName(), tag.getTagId(), tag.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(tag.getGroupId(), AssetTag.class.getName(), tag.getTagId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long tagId, String actionId) throws PortalException {
        AssetTag tag = AssetTagLocalServiceUtil.getTag((long)tagId);
        return AssetTagPermission.contains(permissionChecker, tag, actionId);
    }
}

