/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionCheckerUtil;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

@OSGiBeanProperties(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"})
public class DLFileEntryPermission
implements BaseModelPermissionChecker {
    public static void check(PermissionChecker permissionChecker, DLFileEntry dlFileEntry, String actionId) throws PortalException {
        if (!DLFileEntryPermission.contains(permissionChecker, dlFileEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, FileEntry fileEntry, String actionId) throws PortalException {
        if (!fileEntry.containsPermission(permissionChecker, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, FileEntry.class.getName(), fileEntry.getFileEntryId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException {
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, FileEntry.class.getName(), fileEntryId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileEntry dlFileEntry, String actionId) throws PortalException {
        block14: {
            String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)dlFileEntry.getFileEntryId(), (String)portletId, (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            DLFileVersion currentDLFileVersion = dlFileEntry.getFileVersion();
            if (currentDLFileVersion.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)currentDLFileVersion.getFileVersionId(), (String)actionId)) != null) {
                return hasPermission;
            }
            if (permissionChecker.hasOwnerPermission(dlFileEntry.getCompanyId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), dlFileEntry.getUserId(), actionId)) {
                return true;
            }
            String className = dlFileEntry.getClassName();
            long classPK = dlFileEntry.getClassPK();
            if (Validator.isNotNull((String)className) && classPK > 0L) {
                Boolean hasResourcePermission = ResourcePermissionCheckerUtil.containsResourcePermission((PermissionChecker)permissionChecker, (String)className, (long)classPK, (String)actionId);
                if (hasResourcePermission != null && !hasResourcePermission.booleanValue()) {
                    return false;
                }
                Boolean hasBaseModelPermission = BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)dlFileEntry.getGroupId(), (String)className, (long)classPK, (String)actionId);
                if (hasBaseModelPermission != null && !hasBaseModelPermission.booleanValue()) {
                    return false;
                }
                if (actionId.equals("VIEW") && DLFileEntryPermission._hasActiveWorkflowInstance(permissionChecker.getCompanyId(), dlFileEntry.getGroupId(), currentDLFileVersion.getFileVersionId())) {
                    return false;
                }
            }
            if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long dlFolderId = dlFileEntry.getFolderId();
                if (dlFolderId == 0L) {
                    if (!DLPermission.contains(permissionChecker, dlFileEntry.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    try {
                        DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFolderId);
                        if (!DLFolderPermission.contains(permissionChecker, dlFolder, "ACCESS") && !DLFolderPermission.contains(permissionChecker, dlFolder, "VIEW")) {
                            return false;
                        }
                    }
                    catch (NoSuchFolderException nsfe) {
                        if (dlFileEntry.isInTrash()) break block14;
                        throw nsfe;
                    }
                }
            }
        }
        return permissionChecker.hasPermission(dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, FileEntry fileEntry, String actionId) throws PortalException {
        return fileEntry.containsPermission(permissionChecker, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
        return fileEntry.containsPermission(permissionChecker, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        DLFileEntryPermission.check(permissionChecker, primaryKey, actionId);
    }

    private static boolean _hasActiveWorkflowInstance(long companyId, long groupId, long fileVersionId) throws WorkflowException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink((long)companyId, (long)groupId, (String)DLFileEntryConstants.getClassName(), (long)fileVersionId);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        return !workflowInstance.isComplete();
    }
}

