/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.FolderNameException;
import com.liferay.document.library.kernel.exception.InvalidFileVersionException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public final class DLValidatorImpl
implements DLValidator {
    public String fixName(String name) {
        if (Validator.isNull((String)name)) {
            return "_";
        }
        for (String blacklistChar : PropsValues.DL_CHAR_BLACKLIST) {
            name = StringUtil.replace((String)name, (String)blacklistChar, (String)"_");
        }
        name = this.replaceDLCharLastBlacklist(name);
        return this.replaceDLNameBlacklist(name);
    }

    public boolean isValidName(String name) {
        if (Validator.isNull((String)name)) {
            return false;
        }
        for (String blacklistChar : PropsValues.DL_CHAR_BLACKLIST) {
            if (!name.contains(blacklistChar)) continue;
            return false;
        }
        for (String blacklistLastChar : PropsValues.DL_CHAR_LAST_BLACKLIST) {
            if (blacklistLastChar.startsWith("\\u")) {
                blacklistLastChar = UnicodeFormatter.parseString((String)blacklistLastChar);
            }
            if (!name.endsWith(blacklistLastChar)) continue;
            return false;
        }
        String nameWithoutExtension = FileUtil.stripExtension((String)name);
        for (String blacklistName : PropsValues.DL_NAME_BLACKLIST) {
            if (!StringUtil.equalsIgnoreCase((String)nameWithoutExtension, (String)blacklistName)) continue;
            return false;
        }
        return true;
    }

    public void validateDirectoryName(String directoryName) throws FolderNameException {
        if (!this.isValidName(directoryName)) {
            throw new FolderNameException(directoryName);
        }
    }

    public void validateFileExtension(String fileName) throws FileExtensionException {
        String[] fileExtensions;
        boolean validFileExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray("dl.file.extensions", ",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)fileName, (String)fileExtension)) continue;
            validFileExtension = true;
            break;
        }
        if (!validFileExtension) {
            throw new FileExtensionException(fileName);
        }
    }

    public void validateFileName(String fileName) throws FileNameException {
        if (!this.isValidName(fileName)) {
            throw new FileNameException(fileName);
        }
        if (!DLWebDAVUtil.isRepresentableTitle(fileName)) {
            throw new FileNameException("Unrepresentable WebDAV title for file name " + fileName);
        }
    }

    public void validateFileSize(String fileName, byte[] bytes) throws FileSizeException {
        if (bytes == null) {
            throw new FileSizeException(fileName);
        }
        this.validateFileSize(fileName, bytes.length);
    }

    public void validateFileSize(String fileName, File file) throws FileSizeException {
        if (file == null) {
            throw new FileSizeException(fileName);
        }
        this.validateFileSize(fileName, file.length());
    }

    public void validateFileSize(String fileName, InputStream is) throws FileSizeException {
        try {
            if (is == null) {
                throw new FileSizeException(fileName);
            }
            this.validateFileSize(fileName, is.available());
        }
        catch (IOException ioe) {
            throw new FileSizeException((Throwable)ioe);
        }
    }

    public void validateFileSize(String fileName, long size) throws FileSizeException {
        long maxSize = PrefsPropsUtil.getLong("dl.file.max.size");
        if (maxSize > 0L && size > maxSize) {
            throw new FileSizeException(fileName);
        }
    }

    public void validateSourceFileExtension(String fileExtension, String sourceFileName) throws SourceFileNameException {
        String sourceFileExtension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNotNull((String)sourceFileName) && PropsValues.DL_FILE_EXTENSIONS_STRICT_CHECK && !fileExtension.equals(sourceFileExtension)) {
            throw new SourceFileNameException(sourceFileExtension);
        }
    }

    public void validateVersionLabel(String versionLabel) throws InvalidFileVersionException {
        if (Validator.isNull((String)versionLabel)) {
            return;
        }
        if (!DLUtil.isValidVersion((String)versionLabel)) {
            throw new InvalidFileVersionException("Invalid version label " + versionLabel);
        }
    }

    protected String replaceDLCharLastBlacklist(String title) {
        String previousTitle = null;
        while (!title.equals(previousTitle)) {
            previousTitle = title;
            for (String blacklistLastChar : PropsValues.DL_CHAR_LAST_BLACKLIST) {
                if (blacklistLastChar.startsWith("\\u")) {
                    blacklistLastChar = UnicodeFormatter.parseString((String)blacklistLastChar);
                }
                if (!title.endsWith(blacklistLastChar)) continue;
                title = StringUtil.replaceLast((String)title, (String)blacklistLastChar, (String)"");
            }
        }
        return title;
    }

    protected String replaceDLNameBlacklist(String title) {
        String extension = FileUtil.getExtension((String)title);
        String nameWithoutExtension = FileUtil.stripExtension((String)title);
        for (String blacklistName : PropsValues.DL_NAME_BLACKLIST) {
            if (!StringUtil.equalsIgnoreCase((String)nameWithoutExtension, (String)blacklistName)) continue;
            if (Validator.isNull((String)extension)) {
                return nameWithoutExtension + "_";
            }
            return nameWithoutExtension + "_" + "." + extension;
        }
        return title;
    }
}

