/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompatClassImportsCheck
extends BaseFileCheck {
    private Map<String, String> _compatClassNamesMap;

    @Override
    public void init() throws Exception {
        this._compatClassNamesMap = this.getCompatClassNamesMap();
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isPortalSource() || this.isSubrepository() || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        return this._fixCompatClassImports(content);
    }

    private String _fixCompatClassImports(String content) {
        for (Map.Entry<String, String> entry : this._compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(content)).find()) {
                content = content.substring(0, matcher.start()) + compatClassName + content.substring(matcher.end() - 1);
            }
        }
        return content;
    }
}

