/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Closeable;

public class LoggingTimer
implements Closeable {
    private static final Log _log = LogFactoryUtil.getLog(LoggingTimer.class);
    private final String _name;
    private final long _startTime;

    public LoggingTimer() {
        this(LoggingTimer._getInvokerName(null), System.currentTimeMillis());
    }

    public LoggingTimer(String name) {
        this(LoggingTimer._getInvokerName(name), System.currentTimeMillis());
    }

    @Override
    public void close() {
        if (_log.isInfoEnabled()) {
            _log.info("Completed " + this._name + " in " + (System.currentTimeMillis() - this._startTime) + " ms");
        }
    }

    private static String _getInvokerName(String name) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] stackTraceElements = thread.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[3];
        StringBundler sb = new StringBundler(5);
        sb.append(stackTraceElement.getClassName());
        sb.append("#");
        sb.append(stackTraceElement.getMethodName());
        if (name != null) {
            sb.append("#");
            sb.append(name);
        }
        return sb.toString();
    }

    private LoggingTimer(String name, long startTime) {
        this._name = name;
        this._startTime = startTime;
        if (_log.isInfoEnabled()) {
            _log.info("Starting " + name);
        }
    }
}

