/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.regex.Pattern;

public class StringParserFragment {
    private static final Matcher _defaultMatcher = new DefaultMatcher();
    private static final Map<String, StringParserFragment> _stringParserFragments = new ConcurrentReferenceValueHashMap<String, StringParserFragment>(FinalizeManager.SOFT_REFERENCE_FACTORY);
    private final Matcher _matcher;
    private final String _name;
    private final boolean _raw;
    private final String _token;

    public static StringParserFragment create(String chunk) {
        StringParserFragment stringParserFragment = _stringParserFragments.get(chunk);
        if (stringParserFragment == null) {
            stringParserFragment = new StringParserFragment(chunk);
            _stringParserFragments.put(chunk, stringParserFragment);
        }
        return stringParserFragment;
    }

    public String getName() {
        return this._name;
    }

    public String getPattern() {
        return this._matcher.toString();
    }

    public String getToken() {
        return this._token;
    }

    public boolean isRaw() {
        return this._raw;
    }

    public boolean matches(String parameter) {
        return this._matcher.matches(parameter);
    }

    protected StringParserFragment(String fragment) {
        if (fragment == null || fragment.length() < 3) {
            throw new IllegalArgumentException("Fragment is invalid: " + fragment);
        }
        int index = fragment.indexOf(58);
        String name = null;
        if (index < 0) {
            name = fragment.substring(1, fragment.length() - 1);
            this._matcher = _defaultMatcher;
        } else {
            name = fragment.substring(1, index);
            String pattern = fragment.substring(index + 1, fragment.length() - 1);
            if (Validator.isNull(pattern)) {
                throw new IllegalArgumentException("Pattern is null: " + fragment);
            }
            this._matcher = this._getMatcher(pattern);
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name is null: " + fragment);
        }
        if (name.charAt(0) == '%') {
            if ((name = name.substring(1)).isEmpty()) {
                throw new IllegalArgumentException("Name is invalid: " + fragment);
            }
            this._raw = true;
        } else {
            this._raw = false;
        }
        this._name = name;
        this._token = "{".concat(this._name).concat("}");
    }

    private Matcher _getMatcher(String pattern) {
        if (pattern.equals("\\d+")) {
            return new DigitMatcher();
        }
        if (pattern.equals("[^/]+")) {
            return new NotSlashMatcher();
        }
        if (pattern.equals("(?!id$)[^/]+") || pattern.equals("(?!id/)[^/]+")) {
            return new NotIdMatcher(pattern);
        }
        return new PatternMatcher(pattern);
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }

    private static class PatternMatcher
    implements Matcher {
        private final Pattern _pattern;

        @Override
        public boolean matches(String s) {
            java.util.regex.Matcher matcher = this._pattern.matcher(s);
            return matcher.matches();
        }

        public String toString() {
            return this._pattern.toString();
        }

        private PatternMatcher(String pattern) {
            this._pattern = Pattern.compile(pattern);
        }
    }

    private static class NotSlashMatcher
    implements Matcher {
        private NotSlashMatcher() {
        }

        @Override
        public boolean matches(String s) {
            if (s.isEmpty()) {
                return false;
            }
            return s.indexOf(47) == -1;
        }

        public String toString() {
            return "[^/]+";
        }
    }

    private static class NotIdMatcher
    implements Matcher {
        private final String _pattern;

        @Override
        public boolean matches(String s) {
            return !s.equals("id") && s.indexOf(47) == -1;
        }

        public String toString() {
            return this._pattern;
        }

        private NotIdMatcher(String pattern) {
            this._pattern = pattern;
        }
    }

    private static class DigitMatcher
    implements Matcher {
        private DigitMatcher() {
        }

        @Override
        public boolean matches(String s) {
            if (s.isEmpty()) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "\\d+";
        }
    }

    private static class DefaultMatcher
    implements Matcher {
        private DefaultMatcher() {
        }

        @Override
        public boolean matches(String s) {
            if (s.isEmpty()) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c != '/' && c != '.') continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "[^/\\.]+";
        }
    }
}

