/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArrayCheck
extends BaseFileCheck {
    private final Pattern _addAllArraysAsListPattern = Pattern.compile("\\.addAll\\(\\s*Arrays\\.asList\\(");
    private final Pattern _addAllListUtilFromArrayPattern = Pattern.compile("\\.addAll\\(\\s*ListUtil\\.fromArray\\(");
    private final Pattern _emptyArrayPattern = Pattern.compile("((\\[\\])+) \\{\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkInefficientAddAllCalls(fileName, content, this._addAllArraysAsListPattern);
        this._checkInefficientAddAllCalls(fileName, content, this._addAllListUtilFromArrayPattern);
        return this._formatEmptyArray(content);
    }

    private void _checkInefficientAddAllCalls(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            this.addMessage(fileName, "Use Collections.addAll", "collections.markdown", this.getLineCount(content, matcher.start()));
        }
    }

    private String _formatEmptyArray(String content) {
        Matcher matcher = this._emptyArrayPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.end(1))) continue;
            String replacement = StringUtil.replace(matcher.group(1), "[]", "[0]");
            return StringUtil.replaceFirst(content, matcher.group(), replacement, matcher.start());
        }
        return content;
    }
}

