/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleIllegalImportsCheck
extends BaseFileCheck {
    private boolean _checkRegistryInTestClasses;
    private final Pattern _registryImportPattern = Pattern.compile("\nimport (com\\.liferay\\.registry\\..+);");

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    public void setCheckRegistryInTestClasses(String checkRegistryInTestClasses) {
        this._checkRegistryInTestClasses = GetterUtil.getBoolean(checkRegistryInTestClasses);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher;
        if (fileName.endsWith("JavaModuleIllegalImportsCheck.java")) {
            return content;
        }
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (!packagePath.startsWith("com.liferay")) {
            return content;
        }
        if (!(absolutePath.contains("/modules/core/jaxws-osgi-bridge") || absolutePath.contains("/modules/core/portal-bootstrap") || absolutePath.contains("/modules/core/registry-") || absolutePath.contains("/modules/core/slim-runtime") || !this._checkRegistryInTestClasses && (absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) || !(matcher = this._registryImportPattern.matcher(content)).find())) {
            this.addMessage(fileName, "Do not use com.liferay.registry classes in modules, see LPS-62989");
        }
        if (content.contains("import com.liferay.util.dao.orm.CustomSQLUtil")) {
            this.addMessage(fileName, "Do not use com.liferay.util.dao.orm.CustomSQLUtil in modules, see LPS-64238");
        }
        if (content.contains("import com.liferay.util.ContentUtil")) {
            this.addMessage(fileName, "Do not use com.liferay.util.ContentUtil in modules, see LPS-64335");
        }
        return content;
    }
}

