/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;

public class SubnameCheck
extends AbstractCheck {
    private static final String _MSG_METHOD_INVALID_NAME = "method.invalidName";
    private static final String _MSG_PARAMETER_INVALID_NAME = "parameter.invalidName";
    private static final String _MSG_VARIABLE_INVALID_NAME = "variable.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        if (detailAST.getType() == 9) {
            if (name.matches("(^_?sub|.*Sub)[A-Z].*") && !AnnotationUtility.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
                this.log(detailAST.getLineNo(), _MSG_METHOD_INVALID_NAME, new Object[]{name});
            }
        } else if (name.matches("^_?sub[A-Z].*")) {
            if (detailAST.getType() == 21) {
                this.log(detailAST.getLineNo(), _MSG_PARAMETER_INVALID_NAME, new Object[]{name});
            } else {
                this.log(detailAST.getLineNo(), _MSG_VARIABLE_INVALID_NAME, new Object[]{name});
            }
        }
    }
}

