/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;

public class Canonicalizer {
    private boolean withComments;
    private Serializer serializer;
    private static Comparator comparator = new AttributeComparator();

    public Canonicalizer(OutputStream outputStream) {
        this(outputStream, true);
    }

    public Canonicalizer(OutputStream outputStream, boolean bl) {
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        this.withComments = bl;
    }

    public final void write(Document document) throws IOException {
        this.serializer.write(document);
        this.serializer.flush();
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        CanonicalXMLSerializer(OutputStream outputStream) {
            super(outputStream);
            this.setLineSeparator("\n");
        }

        public final void write(Document document) throws IOException {
            int n = 0;
            while (true) {
                Node node = document.getChild(n);
                this.writeChild(node);
                ++n;
                if (node instanceof ProcessingInstruction) {
                    this.breakLine();
                    continue;
                }
                if (node instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                    continue;
                }
                if (node instanceof Element) break;
            }
            for (int i = n; i < document.getChildCount(); ++i) {
                Node node = document.getChild(i);
                if (node instanceof ProcessingInstruction) {
                    this.breakLine();
                } else if (node instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                }
                this.writeChild(node);
            }
            this.flush();
        }

        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node node = element;
                boolean bl = false;
                int n = -1;
                int[] nArray = new int[10];
                int n2 = 0;
                nArray[0] = -1;
                while (true) {
                    if (!bl && node.getChildCount() > 0) {
                        this.writeStartTag((Element)node, false);
                        node = node.getChild(0);
                        n = 0;
                        nArray = this.grow(nArray, ++n2);
                        nArray[n2] = 0;
                        continue;
                    }
                    if (bl) {
                        this.writeEndTag((Element)node);
                        if (node == element) {
                            break;
                        }
                    } else {
                        this.writeChild(node);
                    }
                    bl = false;
                    ParentNode parentNode = node.getParent();
                    if (parentNode.getChildCount() - 1 == n) {
                        node = parentNode;
                        --n2;
                        if (node != element) {
                            parentNode = node.getParent();
                            n = nArray[n2];
                        }
                        bl = true;
                        continue;
                    }
                    nArray[n2] = ++n;
                    node = parentNode.getChild(n);
                }
            }
        }

        private int[] grow(int[] nArray, int n) {
            if (n < nArray.length) {
                return nArray;
            }
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected void writeStartTag(Element element, boolean bl) throws IOException {
            this.writeRaw("<");
            this.writeRaw(element.getQualifiedName());
            ParentNode parentNode = element.getParent();
            Element element2 = null;
            if (parentNode instanceof Element) {
                element2 = (Element)parentNode;
            }
            for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
                String string = element.getNamespacePrefix(i);
                String string2 = element.getNamespaceURI(string);
                if (element2 != null ? string2.equals(element2.getNamespaceURI(string)) : string2.equals("")) continue;
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(string, string2);
            }
            Attribute[] attributeArray = this.sortAttributes(element);
            for (int i = 0; i < attributeArray.length; ++i) {
                this.writeRaw(" ");
                this.write(attributeArray[i]);
            }
            this.writeRaw(">");
        }

        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        protected void writeEndTag(Element element) throws IOException {
            this.writeRaw("</");
            this.writeRaw(element.getQualifiedName());
            this.writeRaw(">");
        }

        private Attribute[] sortAttributes(Element element) {
            Attribute[] attributeArray = new Attribute[element.getAttributeCount()];
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                attributeArray[i] = element.getAttribute(i);
            }
            Arrays.sort(attributeArray, comparator);
            return attributeArray;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String string = attribute.getValue();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    if (c == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (c == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (c == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } else {
                char[] cArray = string.toCharArray();
                boolean bl = false;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == ' ') {
                        if (i == cArray.length - 1 || cArray[i + 1] == ' ' || !bl) continue;
                        stringBuffer.append(cArray[i]);
                        continue;
                    }
                    bl = true;
                    if (cArray[i] == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (cArray[i] == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (cArray[i] == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (cArray[i] == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (cArray[i] == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (cArray[i] == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(cArray[i]);
                }
            }
            return stringBuffer.toString();
        }

        protected final void write(Text text) throws IOException {
            String string = text.getValue();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\r') {
                    stringBuffer.append("&#xD;");
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                stringBuffer.append(c);
            }
            this.writeRaw(stringBuffer.toString());
        }

        protected final void write(Comment comment) throws IOException {
            if (Canonicalizer.this.withComments) {
                super.write(comment);
            }
        }

        protected final void write(DocType docType) {
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string;
            Attribute attribute = (Attribute)object;
            Attribute attribute2 = (Attribute)object2;
            String string2 = attribute.getNamespaceURI();
            if (string2.equals(string = attribute2.getNamespaceURI())) {
                return attribute.getLocalName().compareTo(attribute2.getLocalName());
            }
            if (string2.equals("")) {
                return -1;
            }
            if (string.equals("")) {
                return 1;
            }
            return string2.compareTo(string);
        }
    }
}

