/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortalCacheManagerProvider {
    private static final PortalCacheManagerProvider _instance = new PortalCacheManagerProvider();
    private final Map<String, PortalCacheManager<? extends Serializable, ?>> _portalCacheManagers = new ConcurrentHashMap();
    private final ServiceTracker<PortalCacheManager<? extends Serializable, ?>, PortalCacheManager<? extends Serializable, ?>> _serviceTracker;

    public static PortalCacheManager<? extends Serializable, ?> getPortalCacheManager(String portalCacheManagerName) {
        return _instance._getPortalCacheManager(portalCacheManagerName);
    }

    public static Collection<PortalCacheManager<? extends Serializable, ?>> getPortalCacheManagers() {
        return _instance._getPortalCacheManagers();
    }

    private PortalCacheManagerProvider() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(PortalCacheManager.class, (ServiceTrackerCustomizer)new PortalCacheProviderServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private PortalCacheManager<? extends Serializable, ?> _getPortalCacheManager(String portalCacheManagerName) {
        return this._portalCacheManagers.get(portalCacheManagerName);
    }

    private Collection<PortalCacheManager<? extends Serializable, ?>> _getPortalCacheManagers() {
        return Collections.unmodifiableCollection(this._portalCacheManagers.values());
    }

    private class PortalCacheProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalCacheManager<? extends Serializable, ?>, PortalCacheManager<? extends Serializable, ?>> {
        private PortalCacheProviderServiceTrackerCustomizer() {
        }

        public PortalCacheManager<? extends Serializable, ?> addingService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalCacheManager portalCacheManager = (PortalCacheManager)registry.getService(serviceReference);
            PortalCacheManagerProvider.this._portalCacheManagers.put(portalCacheManager.getPortalCacheManagerName(), portalCacheManager);
            return portalCacheManager;
        }

        public void modifiedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, PortalCacheManager<? extends Serializable, ?> portalCacheManager) {
        }

        public void removedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, PortalCacheManager<? extends Serializable, ?> portalCacheManager) {
            PortalCacheManagerProvider.this._portalCacheManagers.remove(portalCacheManager.getPortalCacheManagerName());
        }
    }
}

