/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Date;
import java.util.List;

public class UserPasswordException
extends PortalException {
    @Deprecated
    public static final int PASSWORD_ALREADY_USED = 1;
    @Deprecated
    public static final int PASSWORD_CONTAINS_TRIVIAL_WORDS = 2;
    @Deprecated
    public static final int PASSWORD_INVALID = 3;
    @Deprecated
    public static final int PASSWORD_LENGTH = 4;
    @Deprecated
    public static final int PASSWORD_NOT_CHANGEABLE = 5;
    @Deprecated
    public static final int PASSWORD_SAME_AS_CURRENT = 6;
    @Deprecated
    public static final int PASSWORD_TOO_TRIVIAL = 8;
    @Deprecated
    public static final int PASSWORD_TOO_YOUNG = 9;
    @Deprecated
    public static final int PASSWORDS_DO_NOT_MATCH = 10;
    private final int _type;

    @Deprecated
    public UserPasswordException(int type) {
        this._type = type;
    }

    @Deprecated
    public int getType() {
        return this._type;
    }

    private static String _getDictionaryWordsString(List<String> dictionaryWords) {
        if (dictionaryWords.size() <= 10) {
            return dictionaryWords.toString();
        }
        List<String> sampleDictionaryWords = dictionaryWords.subList(0, 10);
        return sampleDictionaryWords.toString() + " " + "...";
    }

    private UserPasswordException(String message, int type) {
        super(message);
        this._type = type;
    }

    public static class MustNotContainDictionaryWords
    extends UserPasswordException {
        public final List<String> dictionaryWords;
        public long userId;

        public MustNotContainDictionaryWords(long userId, List<String> dictionaryWords) {
            super(String.format("Password for user %s must not contain dictionary words such as: %s", userId, UserPasswordException._getDictionaryWordsString(dictionaryWords)), 2);
            this.userId = userId;
            this.dictionaryWords = dictionaryWords;
        }
    }

    public static class MustNotBeTrivial
    extends UserPasswordException {
        public long userId;

        public MustNotBeTrivial(long userId) {
            super(String.format("Password for user %s must not be too trivial", userId), 8);
            this.userId = userId;
        }
    }

    public static class MustNotBeRecentlyUsed
    extends UserPasswordException {
        public long userId;

        public MustNotBeRecentlyUsed(long userId) {
            super(String.format("Password for user %s was used too recently", userId), 1);
            this.userId = userId;
        }
    }

    public static class MustNotBeNull
    extends UserPasswordException {
        public long userId;

        public MustNotBeNull(long userId) {
            super(String.format("Password for user %s must not be null", userId), 3);
            this.userId = userId;
        }
    }

    public static class MustNotBeEqualToCurrent
    extends UserPasswordException {
        public final long userId;

        public MustNotBeEqualToCurrent(long userId) {
            super(String.format("Password for user %s must not be equal to their current password", userId), 6);
            this.userId = userId;
        }
    }

    public static class MustNotBeChangedYet
    extends UserPasswordException {
        public final Date changeableDate;
        public long userId;

        public MustNotBeChangedYet(long userId, Date changeableDate) {
            super(String.format("Password for user %s must not be changed until %s", userId, changeableDate), 9);
            this.userId = userId;
            this.changeableDate = changeableDate;
        }
    }

    public static class MustNotBeChanged
    extends UserPasswordException {
        public final long userId;

        public MustNotBeChanged(long userId) {
            super(String.format("Password for user %s must not be changed under the current password policy", userId), 5);
            this.userId = userId;
        }
    }

    public static class MustMatchCurrentPassword
    extends UserPasswordException {
        public final long userId;

        public MustMatchCurrentPassword(long userId) {
            super(String.format("Password for user %s does not match the current password", userId), 3);
            this.userId = userId;
        }
    }

    public static class MustMatch
    extends UserPasswordException {
        public final long userId;

        public MustMatch(long userId) {
            super(String.format("Passwords for user %s must match", userId), 10);
            this.userId = userId;
        }
    }

    public static class MustComplyWithRegex
    extends UserPasswordException {
        public final String regex;
        public final long userId;

        public MustComplyWithRegex(long userId, String regex) {
            super(String.format("Password must comply with regex: " + regex, new Object[0]), 3);
            this.regex = regex;
            this.userId = userId;
        }
    }

    public static class MustComplyWithModelListeners
    extends UserPasswordException {
        public final ModelListenerException modelListenerException;
        public final long userId;

        public MustComplyWithModelListeners(long userId, ModelListenerException modelListenerException) {
            super(String.format("Password must comply with model listeners: " + modelListenerException.getMessage(), new Object[0]), 3);
            this.userId = userId;
            this.modelListenerException = modelListenerException;
        }
    }

    public static class MustBeLonger
    extends UserPasswordException {
        public final int minLength;
        public final long userId;

        public MustBeLonger(long userId, int minLength) {
            super(String.format("Password for user %s must be at least %s characters", userId, minLength), 4);
            this.minLength = minLength;
            this.userId = userId;
        }
    }
}

