/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.database;

import com.liferay.portal.convert.BaseConvertProcess;
import com.liferay.portal.convert.database.DatabaseConverter;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import java.util.List;
import javax.sql.DataSource;

public class DatabaseConvertProcess
extends BaseConvertProcess {
    private List<DatabaseConverter> _databaseConverters = ServiceTrackerCollections.openList(DatabaseConverter.class);

    public void destroy() {
        this._databaseConverters.clear();
        this._databaseConverters = null;
    }

    @Override
    public String getDescription() {
        return "migrate-data-from-one-database-to-another";
    }

    @Override
    public String getParameterDescription() {
        return "please-enter-jdbc-information-for-new-database";
    }

    @Override
    public String[] getParameterNames() {
        return new String[]{"jdbc-driver-class-name", "jdbc-url", "jdbc-user-name", "jdbc-password"};
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected DataSource buildDatasource() throws Exception {
        String[] values = this.getParameterValues();
        String driverClassName = values[0];
        String url = values[1];
        String userName = values[2];
        String password = values[3];
        String jndiName = "";
        return DataSourceFactoryUtil.initDataSource((String)driverClassName, (String)url, (String)userName, (String)password, (String)jndiName);
    }

    @Override
    protected void doConvert() throws Exception {
        MaintenanceUtil.appendStatus("Starting database migration.");
        DataSource dataSource = this.buildDatasource();
        for (DatabaseConverter databaseConverter : this._databaseConverters) {
            databaseConverter.convert(dataSource);
        }
        MaintenanceUtil.appendStatus("Please change your JDBC settings before restarting server");
        ShutdownUtil.shutdown(0L);
    }
}

