/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import java.util.ArrayList;
import java.util.List;

public class HibernateModelUtil {
    private static final Log _log = LogFactoryUtil.getLog(HibernateModelUtil.class);

    public static List<Class<? extends BaseModel<?>>> getModelClassNames(ClassLoader classLoader, String regex) {
        List modelNames = ModelHintsUtil.getModels();
        ArrayList implClassNames = new ArrayList();
        for (String modelName : modelNames) {
            Class<? extends BaseModel<?>> implClass;
            String implClassName;
            if (!modelName.contains(".model.") || !(implClassName = modelName.replaceFirst("(\\.model\\.)(\\p{Upper}.*)", "$1impl.$2Impl")).matches(regex) || (implClass = HibernateModelUtil.getImplClass(classLoader, implClassName)) == null) continue;
            implClassNames.add(implClass);
        }
        return implClassNames;
    }

    protected static Class<? extends BaseModel<?>> getImplClass(ClassLoader classLoader, String implClassName) {
        try {
            return classLoader.loadClass(implClassName);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }
}

