/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portletfilerepository;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLTrashLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

@DoPrivileged
public class PortletFileRepositoryImpl
implements PortletFileRepository {
    private static final Log _log = LogFactoryUtil.getLog(PortletFileRepositoryImpl.class);

    public void addPortletFileEntries(long groupId, long userId, String className, long classPK, String portletId, long folderId, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        for (int i = 0; i < inputStreamOVPs.size(); ++i) {
            ObjectValuePair<String, InputStream> inputStreamOVP = inputStreamOVPs.get(i);
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            String fileName = (String)inputStreamOVP.getKey();
            this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, inputStream, fileName, "", true);
        }
    }

    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, byte[] bytes, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (bytes == null) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((byte[])bytes);
            FileEntry fileEntry = this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, File file, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (Validator.isNull((String)fileName)) {
            return null;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this.addPortletRepository(groupId, portletId, serviceContext);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        serviceContext.setIndexingEnabled(indexingEnabled);
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            mimeType = MimeTypesUtil.getContentType((File)file, (String)fileName);
        }
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)repository.getRepositoryId());
            FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, fileName, mimeType, fileName, "", "", file, serviceContext);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, InputStream inputStream, String fileName, String mimeType, boolean indexingEnabled) throws PortalException {
        if (inputStream == null) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            FileEntry fileEntry = this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder addPortletFolder(long userId, long repositoryId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)repositoryId);
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            Folder folder = localRepository.getFolder(parentFolderId, folderName);
            return folder;
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            Folder folder = localRepository.addFolder(userId, parentFolderId, folderName, "", serviceContext);
            return folder;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public Folder addPortletFolder(long groupId, long userId, String portletId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        Repository repository = this.addPortletRepository(groupId, portletId, serviceContext);
        return this.addPortletFolder(userId, repository.getRepositoryId(), parentFolderId, folderName, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository addPortletRepository(long groupId, String portletId, ServiceContext serviceContext) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
        if (repository != null) {
            return repository;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        User user = UserLocalServiceUtil.getDefaultUser((long)group.getCompanyId());
        long classNameId = PortalUtil.getClassNameId((String)PortletRepository.class.getName());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            Repository repository2 = RepositoryLocalServiceUtil.addRepository((long)user.getUserId(), (long)groupId, (long)classNameId, (long)0L, (String)portletId, (String)"", (String)portletId, (UnicodeProperties)typeSettingsProperties, (boolean)true, (ServiceContext)serviceContext);
            return repository2;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    @Deprecated
    public void deleteFolder(long folderId) throws PortalException {
        this.deletePortletFolder(folderId);
    }

    public void deletePortletFileEntries(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        List fileEntries = localRepository.getFileEntries(folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
    }

    public void deletePortletFileEntries(long groupId, long folderId, int status) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        List fileEntries = localRepository.getFileEntries(folderId, status, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortletFileEntry(long fileEntryId) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            SystemEventHierarchyEntryThreadLocal.push(FileEntry.class);
            LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository((long)fileEntryId);
            localRepository.deleteFileEntry(fileEntryId);
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsfee, (Throwable)nsfee);
            }
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
            SystemEventHierarchyEntryThreadLocal.pop(FileEntry.class);
        }
    }

    public void deletePortletFileEntry(long groupId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        this.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortletFolder(long folderId) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            SystemEventHierarchyEntryThreadLocal.push(Folder.class);
            LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository((long)folderId);
            localRepository.deleteFolder(folderId);
        }
        catch (NoSuchFolderException nsfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsfe, (Throwable)nsfe);
            }
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
            SystemEventHierarchyEntryThreadLocal.pop(Folder.class);
        }
    }

    public void deletePortletRepository(long groupId, String portletId) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
        if (repository != null) {
            RepositoryLocalServiceUtil.deleteRepository((long)repository.getRepositoryId());
        }
    }

    public FileEntry fetchPortletFileEntry(long groupId, long folderId, String fileName) {
        try {
            return this.getPortletFileEntry(groupId, folderId, fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    public Repository fetchPortletRepository(long groupId, String portletId) {
        return RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
    }

    public String getDownloadPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return this.getDownloadPortletFileEntryURL(themeDisplay, fileEntry, queryString, true);
    }

    public String getDownloadPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        String portletFileEntryURL = this.getPortletFileEntryURL(themeDisplay, fileEntry, queryString, absoluteURL);
        return HttpUtil.addParameter((String)portletFileEntryURL, (String)"download", (boolean)true);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntries(folderId, -1, -1, null);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status) throws PortalException {
        return this.getPortletFileEntries(groupId, folderId, status, -1, -1, null);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntries(folderId, status, start, end, obc);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, OrderByComparator<FileEntry> obc) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntries(folderId, -1, -1, obc);
    }

    public int getPortletFileEntriesCount(long groupId, long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntriesCount(folderId);
    }

    public int getPortletFileEntriesCount(long groupId, long folderId, int status) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntriesCount(folderId, status);
    }

    public FileEntry getPortletFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository((long)fileEntryId);
        return localRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getPortletFileEntry(long groupId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntry(folderId, fileName);
    }

    public FileEntry getPortletFileEntry(String uuid, long groupId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        return localRepository.getFileEntryByUuid(uuid);
    }

    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return this.getPortletFileEntryURL(themeDisplay, fileEntry, queryString, true);
    }

    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        StringBundler sb = new StringBundler(12);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append("portlet_file_entry");
        sb.append("/");
        sb.append(fileEntry.getGroupId());
        sb.append("/");
        String title = fileEntry.getTitle();
        if (fileEntry.isInTrash()) {
            title = TrashUtil.getOriginalTitle((String)fileEntry.getTitle());
        }
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)title)));
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)fileEntry.getUuid()));
        if (Validator.isNotNull((String)queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        String portletFileEntryURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId((String)portletFileEntryURL, (String)themeDisplay.getSessionId());
        }
        return portletFileEntryURL;
    }

    public Folder getPortletFolder(long folderId) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository((long)folderId);
        return localRepository.getFolder(folderId);
    }

    public Folder getPortletFolder(long repositoryId, long parentFolderId, String folderName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)repositoryId);
        return localRepository.getFolder(parentFolderId, folderName);
    }

    public Repository getPortletRepository(long groupId, String portletId) throws PortalException {
        return RepositoryLocalServiceUtil.getRepository((long)groupId, (String)portletId);
    }

    public String getUniqueFileName(long groupId, long folderId, String fileName) {
        String uniqueFileName = fileName;
        int i = 1;
        while (true) {
            try {
                this.getPortletFileEntry(groupId, folderId, uniqueFileName);
                uniqueFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(i));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        return uniqueFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry movePortletFileEntryToTrash(long userId, long fileEntryId) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository((long)fileEntryId);
            FileEntry fileEntry = DLTrashLocalServiceUtil.moveFileEntryToTrash((long)userId, (long)localRepository.getRepositoryId(), (long)fileEntryId);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public FileEntry movePortletFileEntryToTrash(long groupId, long userId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        return this.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder movePortletFolder(long groupId, long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
            Folder folder = localRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
            return folder;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePortletFileEntryFromTrash(long userId, long fileEntryId) throws PortalException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            LocalRepository localRepository = RepositoryProviderUtil.getFileEntryLocalRepository((long)fileEntryId);
            DLTrashLocalServiceUtil.restoreFileEntryFromTrash((long)userId, (long)localRepository.getRepositoryId(), (long)fileEntryId);
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public void restorePortletFileEntryFromTrash(long groupId, long userId, long folderId, String fileName) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getLocalRepository((long)groupId);
        FileEntry fileEntry = localRepository.getFileEntry(folderId, fileName);
        this.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
    }

    public Hits searchPortletFileEntries(long repositoryId, SearchContext searchContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getRepository((long)repositoryId);
        return repository.search(searchContext);
    }
}

