/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileContentReference;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.ModelValidator;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import java.io.File;
import java.io.InputStream;

public class ModelValidatorLocalRepositoryWrapper
extends LocalRepositoryWrapper {
    private final ModelValidator<FileContentReference> _modelValidator;

    public ModelValidatorLocalRepositoryWrapper(LocalRepository localRepository, ModelValidator<FileContentReference> modelValidator) {
        super(localRepository);
        this._modelValidator = modelValidator;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        FileContentReference fileContentReference = FileContentReference.fromFile((String)sourceFileName, (String)DLAppUtil.getExtension(title, sourceFileName), (String)mimeType, (File)file);
        this._modelValidator.validate((Object)fileContentReference);
        return super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileContentReference fileContentReference = FileContentReference.fromInputStream((String)sourceFileName, (String)DLAppUtil.getExtension(title, sourceFileName), (String)mimeType, (InputStream)is, (long)size);
        this._modelValidator.validate((Object)fileContentReference);
        return super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        FileContentReference fileContentReference = FileContentReference.fromFile((long)fileEntryId, (String)sourceFileName, (String)DLAppUtil.getExtension(title, sourceFileName), (String)mimeType, (File)file);
        this._modelValidator.validate((Object)fileContentReference);
        return super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileContentReference fileContentReference = FileContentReference.fromInputStream((long)fileEntryId, (String)sourceFileName, (String)DLAppUtil.getExtension(title, sourceFileName), (String)mimeType, (InputStream)is, (long)size);
        this._modelValidator.validate((Object)fileContentReference);
        return super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
    }
}

