/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.util.RepositoryUserUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class RepositoryWrapper
implements Repository {
    private final Repository _repository;

    public RepositoryWrapper(Repository repository) {
        this._repository = repository;
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
    }

    @Deprecated
    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(RepositoryUserUtil.getUserId(), folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
    }

    @Deprecated
    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileEntry(RepositoryUserUtil.getUserId(), folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFolder(userId, parentFolderId, name, description, serviceContext);
    }

    @Deprecated
    public Folder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.addFolder(RepositoryUserUtil.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        return this._repository.cancelCheckOut(fileEntryId);
    }

    @Deprecated
    public void checkInFileEntry(long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, majorVersion, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(userId, fileEntryId, majorVersion, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    @Deprecated
    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._repository.checkInFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.checkOutFileEntry(fileEntryId, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        return this._repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
    }

    @Deprecated
    public FileEntry copyFileEntry(long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.copyFileEntry(RepositoryUserUtil.getUserId(), groupId, fileEntryId, destFolderId, serviceContext);
    }

    public void deleteAll() throws PortalException {
        this._repository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this._repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntry(long folderId, String title) throws PortalException {
        this._repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this._repository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this._repository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        this._repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this._repository.deleteFolder(folderId);
    }

    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        this._repository.deleteFolder(parentFolderId, name);
    }

    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T)this._repository.getCapability(capabilityClass);
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, status, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, fileEntryTypeId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getFileEntries(folderId, mimeTypes, start, end, obc);
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return this._repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        return this._repository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return this._repository.getFileEntriesCount(folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this._repository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return this._repository.getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return this._repository.getFileEntryByUuid(uuid);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this._repository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this._repository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return this._repository.getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return this._repository.getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getFolders(parentFolderId, includeMountFolders, start, end, obc);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getFolders(parentFolderId, status, includeMountFolders, start, end, obc);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, obc);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimetypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimetypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimetypes, boolean includeMountFolders) throws PortalException {
        return this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimetypes, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this._repository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this._repository.getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        return this._repository.getFoldersFileEntriesCount(folderIds, status);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return this._repository.getMountFolders(parentFolderId, start, end, obc);
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return this._repository.getMountFoldersCount(parentFolderId);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getRepositoryFileEntries(userId, rootFolderId, start, end, obc);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return this._repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, obc);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return this._repository.getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return this._repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    public long getRepositoryId() {
        return this._repository.getRepositoryId();
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        this._repository.getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return this._repository.getSubfolderIds(folderId, recurse);
    }

    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return this._repository.isCapabilityProvided(capabilityClass);
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return this._repository.lockFolder(folderId);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this._repository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
    }

    @Deprecated
    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, newFolderId, serviceContext);
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFolder(userId, folderId, parentFolderId, serviceContext);
    }

    @Deprecated
    public Folder moveFolder(long folderId, long newParentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._repository.moveFolder(RepositoryUserUtil.getUserId(), newParentFolderId, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._repository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._repository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    @Deprecated
    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._repository.revertFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, version, serviceContext);
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return this._repository.search(creatorUserId, status, start, end);
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return this._repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        return this._repository.search(searchContext);
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return this._repository.search(searchContext, query);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        this._repository.unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        this._repository.unlockFolder(parentFolderId, name, lockUuid);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
    }

    @Deprecated
    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
    }

    @Deprecated
    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileEntry(RepositoryUserUtil.getUserId(), fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this._repository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._repository.updateFolder(folderId, name, description, serviceContext);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this._repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return this._repository.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return this._repository.verifyInheritableLock(folderId, lockUuid);
    }
}

