/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.portal.tools.ToolsUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);

    public static String getImports(String content) {
        Matcher matcher = _importsPattern.matcher(content);
        if (matcher.find()) {
            String imports = matcher.group();
            if (imports.endsWith("\n\n")) {
                imports = imports.substring(0, imports.length() - 1);
            }
            return imports;
        }
        return null;
    }

    @Override
    protected ImportPackage createImportPackage(String line) {
        return this.createJavaImportPackage(line);
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packagePath, String className) throws IOException {
        String imports = JavaImportsFormatter.getImports(content);
        if (Validator.isNull((String)imports)) {
            return content;
        }
        String newImports = this.stripUnusedImports(imports, content, packagePath, className, "\\*");
        if (!imports.equals(newImports = this.sortAndGroupImports(newImports))) {
            content = StringUtil.replaceFirst((String)content, (String)imports, (String)newImports);
        }
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        return ToolsUtil.stripFullyQualifiedClassNames(content, newImports, packagePath);
    }
}

