/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;

public class VerifyResourceActions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourceActions.class);

    protected void deleteDuplicateBitwiseValuesOnResource() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select ra1.resourceActionId, ra1.name, ra1.actionId, ");
        sb.append("ra1.bitwiseValue from ResourceAction ra1 inner join ");
        sb.append("ResourceAction ra2 on (ra1.name = ra2.name) and ");
        sb.append("(ra1.bitwiseValue = ra2.bitwiseValue) and (ra1.actionId ");
        sb.append("!= ra2.actionId) order by ra1.resourceActionId");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement(sb.toString());
             ResultSet rs = ps.executeQuery();){
            HashMap<String, HashSet<Long>> nameBitwiseValuesPairs = new HashMap<String, HashSet<Long>>();
            while (rs.next()) {
                String name = rs.getString("name");
                HashSet<Long> bitwiseValues = (HashSet<Long>)nameBitwiseValuesPairs.get(name);
                if (bitwiseValues == null) {
                    bitwiseValues = new HashSet<Long>();
                    nameBitwiseValuesPairs.put(name, bitwiseValues);
                }
                if (bitwiseValues.add(rs.getLong("bitwiseValue"))) continue;
                if (_log.isInfoEnabled()) {
                    sb = new StringBundler(7);
                    sb.append("Deleting resource action ");
                    sb.append(rs.getString("actionId"));
                    sb.append(" from resource ");
                    sb.append(name);
                    sb.append(" because its bitwise value is the ");
                    sb.append("same as another resource action on ");
                    sb.append("the same resource");
                    _log.info((Object)sb.toString());
                }
                ResourceActionLocalServiceUtil.deleteResourceAction((long)rs.getLong("resourceActionId"));
            }
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDuplicateBitwiseValuesOnResource();
    }
}

