/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class AssetSearcher
extends BaseSearcher {
    private AssetEntryQuery _assetEntryQuery;

    public static Indexer<?> getInstance() {
        return new AssetSearcher();
    }

    public AssetSearcher() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getSearchClassNames() {
        long[] classNameIds = this._assetEntryQuery.getClassNameIds();
        String[] classNames = new String[classNameIds.length];
        for (int i = 0; i < classNames.length; ++i) {
            long classNameId = classNameIds[i];
            classNames[i] = PortalUtil.getClassName((long)classNameId);
        }
        return classNames;
    }

    public void setAssetEntryQuery(AssetEntryQuery assetEntryQuery) {
        this._assetEntryQuery = assetEntryQuery;
    }

    protected void addImpossibleTerm(BooleanFilter queryBooleanFilter, String field) throws Exception {
        queryBooleanFilter.addTerm(field, "-1", BooleanClauseOccur.MUST);
    }

    protected void addSearchAllCategories(BooleanFilter queryBooleanFilter) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] allCategoryIds = this._assetEntryQuery.getAllCategoryIds();
        if (allCategoryIds.length == 0) {
            return;
        }
        long[] filteredAllCategoryIds = AssetUtil.filterCategoryIds(permissionChecker, allCategoryIds);
        if (allCategoryIds.length != filteredAllCategoryIds.length) {
            this.addImpossibleTerm(queryBooleanFilter, "assetCategoryIds");
            return;
        }
        BooleanFilter categoryIdsBooleanFilter = new BooleanFilter();
        for (long allCategoryId : filteredAllCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)allCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)allCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(allCategoryId);
            }
            TermsFilter categoryIdTermsFilter = new TermsFilter("assetCategoryIds");
            categoryIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[categoryIds.size()])));
            categoryIdsBooleanFilter.add((Filter)categoryIdTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)categoryIdsBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] allTagIdsArray = this._assetEntryQuery.getAllTagIdsArray();
        if (allTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] allTagIds : allTagIdsArray) {
            if (allTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])allTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyCategories(BooleanFilter queryBooleanFilter) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] anyCategoryIds = this._assetEntryQuery.getAnyCategoryIds();
        if (anyCategoryIds.length == 0) {
            return;
        }
        long[] filteredAnyCategoryIds = AssetUtil.filterCategoryIds(permissionChecker, anyCategoryIds);
        if (filteredAnyCategoryIds.length == 0) {
            this.addImpossibleTerm(queryBooleanFilter, "assetCategoryIds");
            return;
        }
        TermsFilter categoryIdsTermsFilter = new TermsFilter("assetCategoryIds");
        for (long anyCategoryId : filteredAnyCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)anyCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)anyCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(anyCategoryId);
            }
            categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[categoryIds.size()])));
        }
        queryBooleanFilter.add((Filter)categoryIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] anyTagIds = this._assetEntryQuery.getAnyTagIds();
        if (anyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
        tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])anyTagIds));
        queryBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
    }

    protected void addSearchAssetCategoryIds(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllCategories(queryBooleanFilter);
        this.addSearchAnyCategories(queryBooleanFilter);
        this.addSearchNotAnyCategories(queryBooleanFilter);
        this.addSearchNotAllCategories(queryBooleanFilter);
    }

    protected void addSearchAssetTagNames(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchAllTags(queryBooleanFilter);
        this.addSearchAnyTags(queryBooleanFilter);
        this.addSearchNotAllTags(queryBooleanFilter);
        this.addSearchNotAnyTags(queryBooleanFilter);
    }

    protected Map<String, Query> addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return Collections.emptyMap();
        }
        Map queries = super.addSearchKeywords(searchQuery, searchContext);
        String field = DocumentImpl.getLocalizedName((Locale)searchContext.getLocale(), (String)"localized_title");
        Query query = searchQuery.addTerm(field, keywords, true);
        queries.put(field, query);
        return queries;
    }

    protected void addSearchLayout(BooleanFilter queryBooleanFilter, SearchContext searchContext) throws Exception {
        String layoutUuid = (String)((Object)searchContext.getAttribute("layoutUuid"));
        if (Validator.isNotNull((String)layoutUuid)) {
            queryBooleanFilter.addRequiredTerm("layoutUuid", layoutUuid);
        }
    }

    protected void addSearchNotAllCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAllCategoryIds = this._assetEntryQuery.getNotAllCategoryIds();
        if (notAllCategoryIds.length == 0) {
            return;
        }
        BooleanFilter categoryIdsBooleanFilter = new BooleanFilter();
        for (long notAllCategoryId : notAllCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAllCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAllCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(notAllCategoryId);
            }
            TermsFilter categoryIdTermsFilter = new TermsFilter("assetCategoryIds");
            categoryIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[categoryIds.size()])));
            categoryIdsBooleanFilter.add((Filter)categoryIdTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)categoryIdsBooleanFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAllTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[][] notAllTagIdsArray = this._assetEntryQuery.getNotAllTagIdsArray();
        if (notAllTagIdsArray.length == 0) {
            return;
        }
        BooleanFilter tagIdsArrayBooleanFilter = new BooleanFilter();
        for (long[] notAllTagIds : notAllTagIdsArray) {
            if (notAllTagIds.length == 0) continue;
            TermsFilter tagIdsTermsFilter = new TermsFilter("assetTagIds");
            tagIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAllTagIds));
            tagIdsArrayBooleanFilter.add((Filter)tagIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        queryBooleanFilter.add((Filter)tagIdsArrayBooleanFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyCategories(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAnyCategoryIds = this._assetEntryQuery.getNotAnyCategoryIds();
        if (notAnyCategoryIds.length == 0) {
            return;
        }
        TermsFilter categoryIdsTermsFilter = new TermsFilter("assetCategoryIds");
        for (long notAnyCategoryId : notAnyCategoryIds) {
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAnyCategoryId);
            if (assetCategory == null) continue;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAnyCategoryId));
            }
            if (categoryIds.isEmpty()) {
                categoryIds.add(notAnyCategoryId);
            }
            categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])categoryIds.toArray(new Long[categoryIds.size()])));
        }
        queryBooleanFilter.add((Filter)categoryIdsTermsFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyTags(BooleanFilter queryBooleanFilter) throws Exception {
        long[] notAnyTagIds = this._assetEntryQuery.getNotAnyTagIds();
        if (notAnyTagIds.length == 0) {
            return;
        }
        TermsFilter tagIgsTermsFilter = new TermsFilter("assetTagIds");
        tagIgsTermsFilter.addValues(ArrayUtil.toStringArray((long[])notAnyTagIds));
        queryBooleanFilter.add((Filter)tagIgsTermsFilter, BooleanClauseOccur.MUST_NOT);
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        boolean showInvisible = GetterUtil.getBoolean((Object)this._assetEntryQuery.getAttribute("showInvisible"));
        if (showInvisible) {
            return;
        }
        BooleanFilter booleanFilter = fullQuery.getPreBooleanFilter();
        if (booleanFilter == null) {
            booleanFilter = new BooleanFilter();
        }
        booleanFilter.addRequiredTerm("visible", true);
        if (booleanFilter.hasClauses() && !showInvisible) {
            fullQuery.setPreBooleanFilter(booleanFilter);
        }
    }
}

