/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.model.MBBan;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.messageboards.service.base.MBBanServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

public class MBBanServiceImpl
extends MBBanServiceBaseImpl {
    public MBBan addBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        MBPermission.check(permissionChecker, serviceContext.getScopeGroupId(), "BAN_USER");
        User banUser = this.userPersistence.findByPrimaryKey(banUserId);
        boolean groupAdmin = false;
        try {
            groupAdmin = PortalUtil.isGroupAdmin((User)banUser, (long)serviceContext.getScopeGroupId());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        if (groupAdmin) {
            throw new PrincipalException();
        }
        return this.mbBanLocalService.addBan(this.getUserId(), banUserId, serviceContext);
    }

    public void deleteBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        MBPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "BAN_USER");
        this.mbBanLocalService.deleteBan(banUserId, serviceContext);
    }
}

