/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.impl;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.trash.service.base.TrashVersionLocalServiceBaseImpl;
import com.liferay.trash.kernel.model.TrashVersion;
import java.util.List;

public class TrashVersionLocalServiceImpl
extends TrashVersionLocalServiceBaseImpl {
    public TrashVersion addTrashVersion(long trashEntryId, String className, long classPK, int status, UnicodeProperties typeSettingsProperties) {
        long versionId = this.counterLocalService.increment();
        TrashVersion trashVersion = this.trashVersionPersistence.create(versionId);
        trashVersion.setEntryId(trashEntryId);
        trashVersion.setClassName(className);
        trashVersion.setClassPK(classPK);
        if (typeSettingsProperties != null) {
            trashVersion.setTypeSettingsProperties(typeSettingsProperties);
        }
        trashVersion.setStatus(status);
        return (TrashVersion)this.trashVersionPersistence.update((BaseModel)trashVersion);
    }

    public TrashVersion deleteTrashVersion(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        TrashVersion trashVersion = this.trashVersionPersistence.fetchByC_C(classNameId, classPK);
        if (trashVersion != null) {
            return this.deleteTrashVersion(trashVersion);
        }
        return null;
    }

    @Deprecated
    public TrashVersion fetchVersion(long entryId, String className, long classPK) {
        return this.fetchVersion(className, classPK);
    }

    public TrashVersion fetchVersion(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.trashVersionPersistence.fetchByC_C(classNameId, classPK);
    }

    public List<TrashVersion> getVersions(long entryId) {
        return this.trashVersionPersistence.findByEntryId(entryId);
    }

    public List<TrashVersion> getVersions(long entryId, String className) {
        if (Validator.isNull((String)className)) {
            return this.trashVersionPersistence.findByEntryId(entryId);
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.trashVersionPersistence.findByE_C(entryId, classNameId);
    }
}

