/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class RightCurlyCheck
extends AbstractCheck {
    public static final String MSG_KEY_LINE_BREAK_BEFORE = "line.break.before";
    public static final String MSG_KEY_LINE_ALONE = "line.alone";
    public static final String MSG_KEY_LINE_SAME = "line.same";
    public static final String MSG_KEY_LINE_NEW = "line.new";
    private boolean shouldStartLine = true;
    private RightCurlyOption option = RightCurlyOption.SAME;

    public void setOption(String optionStr) {
        try {
            this.option = RightCurlyOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }

    public void setShouldStartLine(boolean flag) {
        this.shouldStartLine = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{95, 96, 97, 83, 92};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{95, 96, 97, 83, 92, 14, 9, 8, 91, 84, 85, 12, 11};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        Details details = RightCurlyCheck.getDetails(ast);
        DetailAST rcurly = details.rcurly;
        if (rcurly != null && rcurly.getType() == 73) {
            String violation;
            if (this.shouldStartLine) {
                String targetSourceLine = this.getLines()[rcurly.getLineNo() - 1];
                violation = RightCurlyCheck.validate(details, this.option, true, targetSourceLine);
            } else {
                violation = RightCurlyCheck.validate(details, this.option, false, "");
            }
            if (!violation.isEmpty()) {
                this.log(rcurly, violation, "}", rcurly.getColumnNo() + 1);
            }
        }
    }

    private static String validate(Details details, RightCurlyOption bracePolicy, boolean shouldStartLine, String targetSourceLine) {
        DetailAST rcurly = details.rcurly;
        DetailAST lcurly = details.lcurly;
        DetailAST nextToken = details.nextToken;
        boolean shouldCheckLastRcurly = details.shouldCheckLastRcurly;
        String violation = "";
        if (bracePolicy == RightCurlyOption.SAME && !RightCurlyCheck.hasLineBreakBefore(rcurly) && lcurly.getLineNo() != rcurly.getLineNo()) {
            violation = MSG_KEY_LINE_BREAK_BEFORE;
        } else if (shouldCheckLastRcurly) {
            if (rcurly.getLineNo() == nextToken.getLineNo()) {
                violation = MSG_KEY_LINE_ALONE;
            }
        } else if (RightCurlyCheck.shouldBeOnSameLine(bracePolicy, details)) {
            violation = MSG_KEY_LINE_SAME;
        } else if (RightCurlyCheck.shouldBeAloneOnLine(bracePolicy, details)) {
            violation = MSG_KEY_LINE_ALONE;
        } else if (shouldStartLine && !RightCurlyCheck.isOnStartOfLine(details, targetSourceLine)) {
            violation = MSG_KEY_LINE_NEW;
        }
        return violation;
    }

    private static boolean shouldBeOnSameLine(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.SAME && details.rcurly.getLineNo() != details.nextToken.getLineNo();
    }

    private static boolean shouldBeAloneOnLine(RightCurlyOption bracePolicy, Details details) {
        return bracePolicy == RightCurlyOption.ALONE && !RightCurlyCheck.isAloneOnLine(details) && !RightCurlyCheck.isEmptyBody(details.lcurly) || bracePolicy == RightCurlyOption.ALONE_OR_SINGLELINE && !RightCurlyCheck.isAloneOnLine(details) && !RightCurlyCheck.isSingleLineBlock(details) && !RightCurlyCheck.isAnonInnerClassInit(details.lcurly) && !RightCurlyCheck.isEmptyBody(details.lcurly);
    }

    private static boolean isOnStartOfLine(Details details, String targetSourceLine) {
        return CommonUtils.hasWhitespaceBefore(details.rcurly.getColumnNo(), targetSourceLine) || details.lcurly.getLineNo() == details.rcurly.getLineNo();
    }

    private static boolean isAloneOnLine(Details details) {
        DetailAST rcurly = details.rcurly;
        DetailAST lcurly = details.lcurly;
        DetailAST nextToken = details.nextToken;
        return rcurly.getLineNo() != lcurly.getLineNo() && rcurly.getLineNo() != nextToken.getLineNo();
    }

    private static boolean isSingleLineBlock(Details details) {
        DetailAST rcurly = details.rcurly;
        DetailAST lcurly = details.lcurly;
        DetailAST nextToken = details.nextToken;
        return rcurly.getLineNo() == lcurly.getLineNo() && rcurly.getLineNo() != nextToken.getLineNo();
    }

    private static boolean isAnonInnerClassInit(DetailAST lcurly) {
        Scope surroundingScope = ScopeUtils.getSurroundingScope(lcurly);
        return surroundingScope.ordinal() == Scope.ANONINNER.ordinal();
    }

    private static Details getDetails(DetailAST ast) {
        DetailAST nextToken;
        DetailAST lcurly;
        boolean shouldCheckLastRcurly = false;
        DetailAST rcurly = null;
        switch (ast.getType()) {
            case 95: {
                lcurly = ast.getFirstChild();
                nextToken = lcurly.getNextSibling();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 96: {
                nextToken = ast.getNextSibling();
                lcurly = ast.getLastChild();
                rcurly = lcurly.getLastChild();
                if (nextToken != null) break;
                shouldCheckLastRcurly = true;
                nextToken = RightCurlyCheck.getNextToken(ast);
                break;
            }
            case 83: {
                nextToken = ast.findFirstToken(92);
                if (nextToken == null) {
                    shouldCheckLastRcurly = true;
                    nextToken = RightCurlyCheck.getNextToken(ast);
                    lcurly = ast.getLastChild();
                    rcurly = lcurly.getLastChild();
                    break;
                }
                lcurly = nextToken.getPreviousSibling();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 92: 
            case 97: {
                shouldCheckLastRcurly = true;
                nextToken = RightCurlyCheck.getNextToken(ast);
                lcurly = ast.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 14: {
                DetailAST child = ast.getLastChild();
                lcurly = child.getFirstChild();
                rcurly = child.getLastChild();
                nextToken = ast;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                lcurly = ast.findFirstToken(7);
                rcurly = lcurly.getLastChild();
                nextToken = RightCurlyCheck.getNextToken(ast);
                break;
            }
            case 85: {
                nextToken = ast.findFirstToken(175);
                lcurly = ast.findFirstToken(7);
                rcurly = lcurly.getLastChild();
                break;
            }
            default: {
                lcurly = ast.findFirstToken(7);
                if (lcurly != null) {
                    rcurly = lcurly.getLastChild();
                }
                nextToken = RightCurlyCheck.getNextToken(ast);
            }
        }
        Details details = new Details();
        details.rcurly = rcurly;
        details.lcurly = lcurly;
        details.nextToken = nextToken;
        details.shouldCheckLastRcurly = shouldCheckLastRcurly;
        return details;
    }

    private static boolean isEmptyBody(DetailAST lcurly) {
        boolean result = false;
        if (lcurly.getParent().getType() == 6) {
            if (lcurly.getNextSibling().getType() == 73) {
                result = true;
            }
        } else if (lcurly.getFirstChild().getType() == 73) {
            result = true;
        }
        return result;
    }

    private static DetailAST getNextToken(DetailAST ast) {
        DetailAST next = null;
        DetailAST parent = ast;
        while (next == null) {
            next = parent.getNextSibling();
            parent = parent.getParent();
        }
        return CheckUtils.getFirstNode(next);
    }

    private static boolean hasLineBreakBefore(DetailAST rightCurly) {
        DetailAST previousToken = rightCurly.getPreviousSibling();
        return previousToken == null || rightCurly.getLineNo() != previousToken.getLineNo();
    }

    private static class Details {
        private DetailAST rcurly;
        private DetailAST lcurly;
        private DetailAST nextToken;
        private boolean shouldCheckLastRcurly;

        private Details() {
        }
    }
}

