/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public abstract class AbstractClassCouplingCheck
extends AbstractCheck {
    private static final Set<String> DEFAULT_EXCLUDED_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"boolean", "byte", "char", "double", "float", "int"}).add((Object[])new String[]{"long", "short", "void"}).add((Object[])new String[]{"Boolean", "Byte", "Character", "Double", "Float"}).add((Object[])new String[]{"Integer", "Long", "Short", "Void"}).add((Object[])new String[]{"Object", "Class"}).add((Object[])new String[]{"String", "StringBuffer", "StringBuilder"}).add((Object[])new String[]{"ArrayIndexOutOfBoundsException", "Exception"}).add((Object[])new String[]{"RuntimeException", "IllegalArgumentException"}).add((Object[])new String[]{"IllegalStateException", "IndexOutOfBoundsException"}).add((Object[])new String[]{"NullPointerException", "Throwable", "SecurityException"}).add((Object)"UnsupportedOperationException").add((Object[])new String[]{"List", "ArrayList", "Deque", "Queue", "LinkedList"}).add((Object[])new String[]{"Set", "HashSet", "SortedSet", "TreeSet"}).add((Object[])new String[]{"Map", "HashMap", "SortedMap", "TreeMap"}).build();
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private Set<String> excludedClasses = DEFAULT_EXCLUDED_CLASSES;
    private int max;
    private String packageName;
    private Context context = new Context("", 0, 0);

    protected AbstractClassCouplingCheck(int defaultMax) {
        this.max = defaultMax;
    }

    protected abstract String getLogMessageId();

    @Override
    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int max) {
        this.max = max;
    }

    public final void setExcludedClasses(String ... excludedClasses) {
        this.excludedClasses = ImmutableSet.copyOf((Object[])excludedClasses);
    }

    @Override
    public final void beginTree(DetailAST ast) {
        this.packageName = "";
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.visitPackageDef(ast);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.visitClassDef(ast);
                break;
            }
            case 13: {
                this.context.visitType(ast);
                break;
            }
            case 136: {
                this.context.visitLiteralNew(ast);
                break;
            }
            case 81: {
                this.context.visitLiteralThrows(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)ast));
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitPackageDef(DetailAST pkg) {
        FullIdent ident = FullIdent.createFullIdent(pkg.getLastChild().getPreviousSibling());
        this.packageName = ident.getText();
    }

    private void visitClassDef(DetailAST classDef) {
        this.contextStack.push(this.context);
        String className = classDef.findFirstToken(58).getText();
        this.context = new Context(className, classDef.getLineNo(), classDef.getColumnNo());
    }

    private void leaveClassDef() {
        this.context.checkCoupling();
        this.context = this.contextStack.pop();
    }

    private class Context {
        private final Set<String> referencedClassNames = Sets.newTreeSet();
        private final String className;
        private final int lineNo;
        private final int columnNo;

        Context(String className, int lineNo, int columnNo) {
            this.className = className;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
        }

        public void visitLiteralThrows(DetailAST literalThrows) {
            for (DetailAST childAST = literalThrows.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                if (childAST.getType() == 74) continue;
                this.addReferencedClassName(childAST);
            }
        }

        public void visitType(DetailAST ast) {
            String fullTypeName = CheckUtils.createFullType(ast).getText();
            AbstractClassCouplingCheck.this.context.addReferencedClassName(fullTypeName);
        }

        public void visitLiteralNew(DetailAST ast) {
            AbstractClassCouplingCheck.this.context.addReferencedClassName(ast.getFirstChild());
        }

        private void addReferencedClassName(DetailAST ast) {
            String fullIdentName = FullIdent.createFullIdent(ast).getText();
            this.addReferencedClassName(fullIdentName);
        }

        private void addReferencedClassName(String referencedClassName) {
            if (this.isSignificant(referencedClassName)) {
                this.referencedClassNames.add(referencedClassName);
            }
        }

        public void checkCoupling() {
            this.referencedClassNames.remove(this.className);
            this.referencedClassNames.remove(AbstractClassCouplingCheck.this.packageName + "." + this.className);
            if (this.referencedClassNames.size() > AbstractClassCouplingCheck.this.max) {
                AbstractClassCouplingCheck.this.log(this.lineNo, this.columnNo, AbstractClassCouplingCheck.this.getLogMessageId(), this.referencedClassNames.size(), AbstractClassCouplingCheck.this.getMax(), this.referencedClassNames.toString());
            }
        }

        private boolean isSignificant(String candidateClassName) {
            return !AbstractClassCouplingCheck.this.excludedClasses.contains(candidateClassName) && !candidateClassName.startsWith("java.lang.");
        }
    }
}

