/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArrayCheck
extends BaseFileCheck {
    private final Pattern _addAllArraysAsListPattern = Pattern.compile("\\.addAll\\(\\s*Arrays\\.asList\\(");
    private final Pattern _addAllListUtilFromArrayPattern = Pattern.compile("\\.addAll\\(\\s*ListUtil\\.fromArray\\(");
    private final Pattern _arrayInitializationPattern = Pattern.compile("(\\W\\w+(\\[\\])+)(\\s+)(\\w+ =)((\\s+)new \\w+(\\[\\])+)( \\{(\n)?)");
    private final Pattern _emptyArrayPattern = Pattern.compile("((\\[\\])+) \\{\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkInefficientAddAllCalls(fileName, content, this._addAllArraysAsListPattern);
        this._checkInefficientAddAllCalls(fileName, content, this._addAllListUtilFromArrayPattern);
        content = this._formatArrayInitializer(content);
        return this._formatEmptyArray(content);
    }

    private void _checkInefficientAddAllCalls(String fileName, String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            this.addMessage(fileName, "Use Collections.addAll", "collections.markdown", this.getLineCount(content, matcher.start()));
        }
    }

    private String _formatArrayInitializer(String content) {
        Matcher matcher = this._arrayInitializationPattern.matcher(content);
        if (matcher.find()) {
            int start;
            String whitespace = matcher.group(6);
            if (!whitespace.contains("\n")) {
                return StringUtil.replaceFirst(content, matcher.group(5), "", matcher.start(5));
            }
            int lineCount = this.getLineCount(content, matcher.end(3));
            String line = this.getLine(content, lineCount);
            if (this.getLineLength(line) > this.getMaxLineLength() - 2) {
                String whitespace2 = matcher.group(3);
                if (whitespace2.contains("\n")) {
                    System.out.println(matcher.group());
                    return content;
                }
                return StringUtil.replaceFirst(content, matcher.group(), matcher.group(1) + whitespace + matcher.group(4) + matcher.group(8));
            }
            if (matcher.group(9) == null) {
                return StringUtil.replaceFirst(content, matcher.group(5), "", matcher.start(5));
            }
            content = StringUtil.replaceFirst(content, matcher.group(), matcher.group(1) + matcher.group(3) + matcher.group(4) + " {\n", matcher.start());
            int level = 1;
            int count = start = lineCount + 1;
            while ((level += this.getLevel(this.getLine(content, count), "{", "}")) != 0) {
                ++count;
            }
            for (int i = start; i <= count; ++i) {
                content = StringUtil.replaceFirst(content, "\t", "", this.getLineStartPos(content, i));
            }
            return content;
        }
        return content;
    }

    private String _formatEmptyArray(String content) {
        Matcher matcher = this._emptyArrayPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.end(1))) continue;
            String replacement = StringUtil.replace(matcher.group(1), "[]", "[0]");
            return StringUtil.replaceFirst(content, matcher.group(), replacement, matcher.start());
        }
        return content;
    }
}

