/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaServiceUtilCheck
extends BaseFileCheck {
    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String className = JavaSourceUtil.getClassName(fileName);
        if (!absolutePath.contains("/wsrp/internal/bind/") && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && content.matches("(?s).*import com\\.liferay\\.[a-z]+\\.kernel\\..*ServiceUtil;.*")) {
            this.addMessage(fileName, "Do not use a portal-kernel *ServiceUtil in a *ServiceImpl class, create a reference via service.xml instead");
        }
        return content;
    }
}

