/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.JSPImportsFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPImportsCheck
extends BaseFileCheck {
    private final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*(?:page|tag) import=\".*>\n*)+", 8);
    private final Pattern _compressedJSPTaglibPattern = Pattern.compile("(<.*\n*taglib uri=\".*>\n*)+", 8);
    private final Pattern _incorrectTaglibPattern = Pattern.compile("(taglib )(prefix=\".+\") (uri=\".*\")");
    private final Pattern _uncompressedJSPImportPattern = Pattern.compile("(<.*(?:page|tag) import=\".*>\n*)+", 8);
    private final Pattern _uncompressedJSPTaglibPattern = Pattern.compile("(<.*taglib uri=\".*>\n*)+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatJSPImportsOrTaglibs(fileName, content, this._compressedJSPImportPattern, this._uncompressedJSPImportPattern);
        content = this._formatJSPImportsOrTaglibs(fileName, content, this._compressedJSPTaglibPattern, this._uncompressedJSPTaglibPattern);
        if (!(!this.isPortalSource() && !this.isSubrepository() || !content.contains("page import=") || fileName.contains("init.jsp") || fileName.contains("init.tag") || fileName.contains("init-ext.jsp") || fileName.contains("/taglib/aui/") || fileName.endsWith("touch.jsp") || !fileName.endsWith(".jspf") && !content.contains("include file="))) {
            this.addMessage(fileName, "Move imports to init.jsp");
        }
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ page import=");
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ tag import=");
        content = JSPSourceUtil.compressImportsOrTaglibs(fileName, content, "<%@ taglib uri=");
        Matcher matcher = this._incorrectTaglibPattern.matcher(content);
        return matcher.replaceAll("$1$3 $2");
    }

    private String _formatJSPImportsOrTaglibs(String fileName, String content, Pattern compressedPattern, Pattern uncompressedPattern) throws Exception {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = compressedPattern.matcher(content);
        ArrayList<String> groups = new ArrayList<String>();
        while (matcher.find()) {
            groups.add(matcher.group());
        }
        if (groups.isEmpty()) {
            return content;
        }
        String imports = StringUtil.merge(groups, "\n");
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        for (int i = 1; i < groups.size(); ++i) {
            content = StringUtil.removeSubstring(content, (String)groups.get(i));
        }
        content = StringUtil.replaceFirst(content, (String)groups.get(0), newImports + "\n\n");
        content = StringUtil.replaceFirst(content, imports, newImports);
        JSPImportsFormatter importsFormatter = new JSPImportsFormatter();
        return importsFormatter.format(content, uncompressedPattern);
    }
}

