/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLResourceActionsFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.contains("/resource-actions/")) {
            this._checkResourceActionXML(fileName, content, "model");
            this._checkResourceActionXML(fileName, content, "portlet");
        }
        return content;
    }

    private void _checkResourceActionXML(String fileName, String content, String type) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List resourceElements = rootElement.elements(type + "-resource");
        for (Element resourceElement : resourceElements) {
            Element nameElement = resourceElement.element(type + "-name");
            if (nameElement == null) continue;
            String name = nameElement.getText();
            Element permissionsElement = resourceElement.element("permissions");
            if (permissionsElement == null) continue;
            List permissionsChildElements = permissionsElement.elements();
            for (Element permissionsChildElement : permissionsChildElements) {
                this.checkElementOrder(fileName, permissionsChildElement, "action-key", name, new ResourceActionActionKeyElementComparator());
            }
        }
        this.checkElementOrder(fileName, rootElement, type + "-resource", null, new ResourceActionResourceElementComparator(type + "-name"));
    }

    private class ResourceActionResourceElementComparator
    extends ElementComparator {
        public ResourceActionResourceElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public String getElementName(Element portletResourceElement) {
            Element portletNameElement = portletResourceElement.element(this.getNameAttribute());
            if (portletNameElement == null) {
                return null;
            }
            return portletNameElement.getText();
        }
    }

    private class ResourceActionActionKeyElementComparator
    extends ElementComparator {
        private ResourceActionActionKeyElementComparator() {
        }

        @Override
        public String getElementName(Element actionKeyElement) {
            return actionKeyElement.getStringValue();
        }
    }
}

