/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.ThreadSafeSortedClassLibraryBuilder;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UnprocessedExceptionCheck
extends AbstractCheck {
    private static final String _MSG_UNPROCESSED_EXCEPTION = "exception.unprocessed";

    public int[] getDefaultTokens() {
        return new int[]{96, 136};
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return;
        }
        if (detailAST.getType() == 96) {
            FileText fileText = fileContents.getText();
            this._checkUnprocessedException(detailAST, (String)fileText.getFullText());
        } else {
            this._checkUnprocessedThrownException(detailAST);
        }
    }

    private void _checkUnprocessedException(DetailAST detailAST, String content) {
        String packageName;
        JavaClass exceptionClass;
        DetailAST parameterDefAST = detailAST.findFirstToken(21);
        String exceptionVariableName = this._getName(parameterDefAST);
        if (this._containsVariable(detailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        String exceptionClassName = this._getExceptionClassName(parameterDefAST);
        if (exceptionClassName == null) {
            return;
        }
        String originalExceptionClassName = exceptionClassName;
        JavaProjectBuilder javaProjectBuilder = this._getJavaProjectBuilder(content);
        if (javaProjectBuilder == null) {
            return;
        }
        if (!exceptionClassName.contains(".")) {
            for (String importedExceptionClassName : this._getImportedExceptionClassNames(javaProjectBuilder)) {
                if (!importedExceptionClassName.endsWith("." + exceptionClassName)) continue;
                exceptionClassName = importedExceptionClassName;
                break;
            }
        }
        if (!exceptionClassName.contains(".")) {
            exceptionClassName = JavaSourceUtil.getPackagePath(content) + "." + exceptionClassName;
        }
        if ((exceptionClass = javaProjectBuilder.getClassByName(exceptionClassName)) == null) {
            return;
        }
        while ((packageName = exceptionClass.getPackageName()).contains("com.liferay")) {
            exceptionClassName = exceptionClass.getName();
            if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                this.log(parameterDefAST.getLineNo(), _MSG_UNPROCESSED_EXCEPTION, new Object[]{originalExceptionClassName});
                break;
            }
            JavaClass exceptionSuperClass = exceptionClass.getSuperJavaClass();
            if (exceptionSuperClass == null) break;
            exceptionClass = exceptionSuperClass;
        }
    }

    private void _checkUnprocessedThrownException(DetailAST detailAST) {
        String name = this._getName(detailAST);
        if (name == null || !name.endsWith("Exception")) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() != 28) {
            return;
        }
        DetailAST exprAST = parentAST;
        while (true) {
            if (parentAST == null) {
                return;
            }
            if (parentAST.getType() == 96) break;
            parentAST = parentAST.getParent();
        }
        DetailAST parameterDefAST = parentAST.findFirstToken(21);
        String exceptionVariableName = this._getName(parameterDefAST);
        if (this._containsVariable(parentAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        parentAST = exprAST.getParent();
        if (parentAST.getType() == 90 || parentAST.getType() == 7) {
            this.log(detailAST.getLineNo(), _MSG_UNPROCESSED_EXCEPTION, new Object[]{exceptionVariableName});
        }
    }

    private boolean _containsVariable(DetailAST detailAST, String variableName) {
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameAST : nameASTList) {
            String name = nameAST.getText();
            if (!name.equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private String _getExceptionClassName(DetailAST parameterDefAST) {
        DetailAST typeAST = parameterDefAST.findFirstToken(13);
        FullIdent typeIdent = FullIdent.createFullIdentBelow((DetailAST)typeAST);
        return typeIdent.getText();
    }

    private Set<String> _getImportedExceptionClassNames(JavaProjectBuilder javaProjectBuilder) {
        HashSet<String> exceptionClassNames = new HashSet<String>();
        Collection sources = javaProjectBuilder.getSources();
        JavaSource javaSource = (JavaSource)sources.iterator().next();
        for (String importClassName : javaSource.getImports()) {
            if (!importClassName.endsWith("Exception")) continue;
            exceptionClassNames.add(importClassName);
        }
        return exceptionClassNames;
    }

    private JavaProjectBuilder _getJavaProjectBuilder(String content) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder((ClassLibraryBuilder)new ThreadSafeSortedClassLibraryBuilder());
        try {
            javaProjectBuilder.addSource((Reader)new UnsyncStringReader(content));
        }
        catch (ParseException pe) {
            return null;
        }
        return javaProjectBuilder;
    }

    private String _getName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        if (nameAST != null) {
            return nameAST.getText();
        }
        DetailAST dotAST = detailAST.findFirstToken(59);
        if (dotAST != null) {
            nameAST = dotAST.findFirstToken(58);
            return nameAST.getText();
        }
        return null;
    }
}

