/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import antlr.CommonASTWithHiddenTokens;
import antlr.Token;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.BitSet;

public final class DetailAST
extends CommonASTWithHiddenTokens {
    private static final long serialVersionUID = -2580884815577559874L;
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int lineNo = Integer.MIN_VALUE;
    private int columnNo = Integer.MIN_VALUE;
    private int childCount = Integer.MIN_VALUE;
    private DetailAST parent;
    private DetailAST previousSibling;
    private BitSet branchTokenTypes;

    public void initialize(Token tok) {
        super.initialize(tok);
        this.lineNo = tok.getLine();
        this.columnNo = tok.getColumn() - 1;
    }

    public void initialize(AST ast) {
        DetailAST detailAst = (DetailAST)ast;
        this.setText(detailAst.getText());
        this.setType(detailAst.getType());
        this.lineNo = detailAst.getLineNo();
        this.columnNo = detailAst.getColumnNo();
        this.hiddenAfter = detailAst.getHiddenAfter();
        this.hiddenBefore = detailAst.getHiddenBefore();
    }

    public void setFirstChild(AST ast) {
        this.childCount = Integer.MIN_VALUE;
        super.setFirstChild(ast);
        if (ast != null) {
            ((DetailAST)ast).setParent(this);
        }
    }

    public void setNextSibling(AST ast) {
        super.setNextSibling(ast);
        if (ast != null && this.parent != null) {
            ((DetailAST)ast).setParent(this.parent);
        }
        if (ast != null) {
            ((DetailAST)ast).previousSibling = this;
        }
    }

    public void addPreviousSibling(DetailAST ast) {
        if (ast != null) {
            ast.setParent(this.parent);
            DetailAST previousSiblingNode = this.previousSibling;
            if (previousSiblingNode != null) {
                ast.previousSibling = previousSiblingNode;
                previousSiblingNode.setNextSibling((AST)ast);
            } else if (this.parent != null) {
                this.parent.setFirstChild((AST)ast);
            }
            ast.setNextSibling((AST)this);
            this.previousSibling = ast;
        }
    }

    public void addNextSibling(DetailAST ast) {
        if (ast != null) {
            ast.setParent(this.parent);
            DetailAST nextSibling = this.getNextSibling();
            if (nextSibling != null) {
                ast.setNextSibling((AST)nextSibling);
                nextSibling.previousSibling = ast;
            }
            ast.previousSibling = this;
            this.setNextSibling((AST)ast);
        }
    }

    public void addChild(AST ast) {
        super.addChild(ast);
        if (ast != null) {
            ((DetailAST)ast).setParent(this);
            this.getFirstChild().setParent(this);
        }
    }

    public int getChildCount() {
        if (this.childCount == Integer.MIN_VALUE) {
            this.childCount = 0;
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                ++this.childCount;
            }
        }
        return this.childCount;
    }

    public int getChildCount(int type) {
        int count = 0;
        for (DetailAST ast = this.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != type) continue;
            ++count;
        }
        return count;
    }

    private void setParent(DetailAST parent) {
        this.parent = parent;
        DetailAST nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            nextSibling.setParent(parent);
            nextSibling.previousSibling = this;
        }
    }

    public DetailAST getParent() {
        return this.parent;
    }

    public int getLineNo() {
        int resultNo = -1;
        if (this.lineNo == Integer.MIN_VALUE && (resultNo = DetailAST.findLineNo(this.getFirstChild())) < 0) {
            resultNo = DetailAST.findLineNo(this.getNextSibling());
        }
        if (resultNo < 0) {
            resultNo = this.lineNo;
        }
        return resultNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getColumnNo() {
        int resultNo = -1;
        if (this.columnNo == Integer.MIN_VALUE && (resultNo = DetailAST.findColumnNo(this.getFirstChild())) < 0) {
            resultNo = DetailAST.findColumnNo(this.getNextSibling());
        }
        if (resultNo < 0) {
            resultNo = this.columnNo;
        }
        return resultNo;
    }

    public void setColumnNo(int columnNo) {
        this.columnNo = columnNo;
    }

    public DetailAST getLastChild() {
        DetailAST ast;
        for (ast = this.getFirstChild(); ast != null && ast.getNextSibling() != null; ast = ast.getNextSibling()) {
        }
        return ast;
    }

    private static int findColumnNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtils.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getColumnNo();
            break;
        }
        return resultNo;
    }

    private static int findLineNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtils.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getLineNo();
            break;
        }
        return resultNo;
    }

    private BitSet getBranchTokenTypes() {
        if (this.branchTokenTypes == null) {
            this.branchTokenTypes = new BitSet();
            this.branchTokenTypes.set(this.getType());
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.branchTokenTypes.or(childTypes);
            }
        }
        return this.branchTokenTypes;
    }

    public boolean branchContains(int type) {
        return this.getBranchTokenTypes().get(type);
    }

    public DetailAST getPreviousSibling() {
        return this.previousSibling;
    }

    public DetailAST findFirstToken(int type) {
        DetailAST returnValue = null;
        for (DetailAST ast = this.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != type) continue;
            returnValue = ast;
            break;
        }
        return returnValue;
    }

    public String toString() {
        return super.toString() + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }

    public DetailAST getNextSibling() {
        return (DetailAST)super.getNextSibling();
    }

    public DetailAST getFirstChild() {
        return (DetailAST)super.getFirstChild();
    }
}

