/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class DefaultScreenNameGenerator
implements ScreenNameGenerator {
    private static final String[] _ADMIN_RESERVED_SCREEN_NAMES = StringUtil.splitLines(PropsUtil.get("admin.reserved.screen.names"));
    private static final String _NON_NUMERICAL_PREFIX = "user.";
    private static final boolean _USERS_SCREEN_NAME_ALLOW_NUMERIC = GetterUtil.getBoolean(PropsUtil.get("users.screen.name.allow.numeric"));

    @Override
    public String generate(long companyId, long userId, String emailAddress) throws Exception {
        String[] reservedScreenNames;
        String screenName = null;
        if (Validator.isNotNull(emailAddress)) {
            screenName = StringUtil.extractFirst(emailAddress, '@');
            screenName = StringUtil.toLowerCase(screenName);
            for (char c : screenName.toCharArray()) {
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '.') continue;
                screenName = StringUtil.replace(screenName, c, '.');
            }
            if (screenName.equals("postfix")) {
                screenName = screenName + "." + userId;
            }
        } else {
            screenName = String.valueOf(userId);
        }
        if (!_USERS_SCREEN_NAME_ALLOW_NUMERIC && Validator.isNumber(screenName)) {
            screenName = _NON_NUMERICAL_PREFIX + screenName;
        }
        for (String reservedScreenName : reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", _ADMIN_RESERVED_SCREEN_NAMES)) {
            if (!StringUtil.equalsIgnoreCase(screenName, reservedScreenName)) continue;
            return this.getUnusedScreenName(companyId, screenName);
        }
        if (UserLocalServiceUtil.fetchUserByScreenName(companyId, screenName) != null) {
            return this.getUnusedScreenName(companyId, screenName);
        }
        if (GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + screenName) == null) {
            return screenName;
        }
        return this.getUnusedScreenName(companyId, screenName);
    }

    protected String getUnusedScreenName(long companyId, String screenName) {
        int i = 1;
        String tempScreenName;
        while (UserLocalServiceUtil.fetchUserByScreenName(companyId, tempScreenName = screenName + "." + i) != null || GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + tempScreenName) != null) {
            ++i;
        }
        return tempScreenName;
    }
}

