/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.PredicateFilter;

public class AggregatePredicateFilter<T>
implements PredicateFilter<T> {
    private PredicateFilter<T> _predicateFilter;

    public AggregatePredicateFilter(PredicateFilter<T> predicateFilter) {
        this._predicateFilter = new IdentityPredicateFilter<T>(predicateFilter);
    }

    public AggregatePredicateFilter<T> and(PredicateFilter<T> predicateFilter) {
        this._predicateFilter = new AndPredicateFilter<T>(this._predicateFilter, new IdentityPredicateFilter<T>(predicateFilter));
        return this;
    }

    @Override
    public boolean filter(T t) {
        return this._predicateFilter.filter(t);
    }

    public AggregatePredicateFilter<T> negate() {
        this._predicateFilter = new NegatePredicateFilter<T>(this._predicateFilter);
        return this;
    }

    public AggregatePredicateFilter<T> or(PredicateFilter<T> predicateFilter) {
        this._predicateFilter = new OrPredicateFilter<T>(this._predicateFilter, new IdentityPredicateFilter<T>(predicateFilter));
        return this;
    }

    private static class OrPredicateFilter<T>
    implements PredicateFilter<T> {
        private PredicateFilter<T> _leftPredicateFilter;
        private PredicateFilter<T> _rightPredicateFilter;

        public OrPredicateFilter(PredicateFilter<T> leftPredicateFilter, PredicateFilter<T> rightPredicateFilter) {
            this._leftPredicateFilter = leftPredicateFilter;
            this._rightPredicateFilter = rightPredicateFilter;
        }

        @Override
        public boolean filter(T t) {
            return this._leftPredicateFilter.filter(t) || this._rightPredicateFilter.filter(t);
        }
    }

    private static class NegatePredicateFilter<T>
    implements PredicateFilter<T> {
        private PredicateFilter<T> _predicateFilter;

        public NegatePredicateFilter(PredicateFilter<T> predicateFilter) {
            this._predicateFilter = predicateFilter;
        }

        @Override
        public boolean filter(T t) {
            return !this._predicateFilter.filter(t);
        }
    }

    private static class IdentityPredicateFilter<T>
    implements PredicateFilter<T> {
        private final PredicateFilter<T> _predicateFilter;

        public IdentityPredicateFilter(PredicateFilter<T> predicateFilter) {
            this._predicateFilter = predicateFilter;
        }

        @Override
        public boolean filter(T t) {
            return this._predicateFilter.filter(t);
        }
    }

    private static class AndPredicateFilter<T>
    implements PredicateFilter<T> {
        private PredicateFilter<T> _leftPredicateFilter;
        private PredicateFilter<T> _rightPredicateFilter;

        public AndPredicateFilter(PredicateFilter<T> leftPredicateFilter, PredicateFilter<T> rightPredicateFilter) {
            this._leftPredicateFilter = leftPredicateFilter;
            this._rightPredicateFilter = rightPredicateFilter;
        }

        @Override
        public boolean filter(T t) {
            return this._leftPredicateFilter.filter(t) && this._rightPredicateFilter.filter(t);
        }
    }
}

