/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aspectj;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class URLWeavingAdapter
extends WeavingAdaptor {
    private final Map<String, byte[]> _generatedClasses = new HashMap<String, byte[]>();

    public URLWeavingAdapter(URL[] urls, Class<?>[] aspectClasses) {
        super(null, urls, new URL[0]);
        this.generatedClassHandler = new RecordGeneratedClassHandler();
        for (Class<?> aspectClass : aspectClasses) {
            this._addAspectClass(aspectClass);
        }
        this.weaver.prepareForWeave();
    }

    public byte[] removeGeneratedClassDate(String name) {
        return this._generatedClasses.remove(name);
    }

    /*
     * Unable to fully structure code
     */
    private void _addAspectClass(Class<?> aspectClass) {
        currentClass = aspectClass;
        while (true) {
            for (Class<?> interfaceClass : interfaceClasses = currentClass.getInterfaces()) {
                javaClass = this._classToJavaClass(interfaceClass);
                if (javaClass == null) continue;
                this.bcelWorld.addSourceObjectType(javaClass, false);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
            javaClass = this._classToJavaClass(currentClass);
            if (javaClass == null) ** continue;
            this.bcelWorld.addSourceObjectType(javaClass, false);
        }
        javaClass = this._classToJavaClass(aspectClass);
        bcelObjectType = this.bcelWorld.addSourceObjectType(javaClass, false);
        resolvedType = bcelObjectType.getResolvedTypeX();
        if (!resolvedType.isAspect()) {
            throw new IllegalArgumentException("Class object " + aspectClass + " is not an aspect");
        }
        crosscuttingMembersSet = this.bcelWorld.getCrosscuttingMembersSet();
        crosscuttingMembersSet.addOrReplaceAspect((ResolvedType)resolvedType);
    }

    private JavaClass _classToJavaClass(Class<?> aspectClass) {
        ClassLoader aspectClassLoader = aspectClass.getClassLoader();
        if (aspectClassLoader == null) {
            aspectClassLoader = ClassLoader.getSystemClassLoader();
        }
        String resourcePath = aspectClass.getName();
        resourcePath = resourcePath.replace('.', '/') + ".class";
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = aspectClassLoader.getResourceAsStream(resourcePath);
        if (inputStream instanceof ByteArrayInputStream) {
            byteArrayInputStream = (ByteArrayInputStream)inputStream;
        } else {
            try {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
                byte[] classData = unsyncByteArrayOutputStream.unsafeGetByteArray();
                byteArrayInputStream = new ByteArrayInputStream(classData, 0, unsyncByteArrayOutputStream.size());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to reload class data", ioe);
            }
        }
        ClassParser classParser = new ClassParser(byteArrayInputStream, aspectClass.getSimpleName() + ".class");
        try {
            return classParser.parse();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse class data", e);
        }
    }

    private class RecordGeneratedClassHandler
    implements GeneratedClassHandler {
        private RecordGeneratedClassHandler() {
        }

        public void acceptClass(String name, byte[] originalBytes, byte[] weavedBytes) {
            URLWeavingAdapter.this._generatedClasses.put(name, weavedBytes);
        }
    }
}

