/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ResourceBlock;
import com.liferay.portal.model.impl.ResourceBlockModelImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;

public class ResourceBlockModelListener
extends BaseModelListener<ResourceBlock> {
    private static final long _CLEAR_ON_BEFORE_BITMASK = 7L;

    public void onAfterCreate(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onAfterRemove(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onAfterUpdate(ResourceBlock resourceBlock) {
        this._clearCache(resourceBlock);
    }

    public void onBeforeUpdate(ResourceBlock resourceBlock) {
        ResourceBlockModelImpl resourceBlockModelImpl = (ResourceBlockModelImpl)resourceBlock;
        long columnBitmask = resourceBlockModelImpl.getColumnBitmask();
        if ((columnBitmask & 7L) != 0L) {
            PermissionCacheUtil.clearResourceBlockCache(resourceBlockModelImpl.getOriginalCompanyId(), resourceBlockModelImpl.getOriginalGroupId(), resourceBlockModelImpl.getOriginalName());
        }
    }

    private void _clearCache(ResourceBlock resourceBlock) {
        if (resourceBlock != null) {
            PermissionCacheUtil.clearResourceBlockCache(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName());
            PermissionCacheUtil.clearResourcePermissionCache(4, resourceBlock.getName(), String.valueOf(resourceBlock.getPrimaryKey()));
        }
    }
}

