/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryUtil;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import java.io.InputStream;
import java.util.List;

public class FileEntryUtil {
    public static FileEntry fetchByPrimaryKey(long fileEntryId) {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)fileEntryId);
        if (dlFileEntry == null) {
            return null;
        }
        return new LiferayFileEntry(dlFileEntry);
    }

    public static FileEntry fetchByR_F_FN(long repositoryId, long folderId, String fileName) {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByFileName((long)repositoryId, (long)folderId, (String)fileName);
        if (dlFileEntry == null) {
            return null;
        }
        return new LiferayFileEntry(dlFileEntry);
    }

    public static FileEntry fetchByR_F_T(long repositoryId, long folderId, String title) {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntry((long)repositoryId, (long)folderId, (String)title);
        if (dlFileEntry == null) {
            return null;
        }
        return new LiferayFileEntry(dlFileEntry);
    }

    public static FileEntry fetchByUUID_R(String uuid, long repositoryId) {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntry((String)uuid, (long)repositoryId);
        if (dlFileEntry == null) {
            return null;
        }
        return new LiferayFileEntry(dlFileEntry);
    }

    @Deprecated
    public static List<FileEntry> findByR_F(long repositoryId, long folderId) {
        List dlFileEntries = DLFileEntryUtil.findByG_F((long)repositoryId, (long)folderId);
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    @Deprecated
    public static FileEntry findByR_F_T(long repositoryId, long folderId, String title) throws NoSuchFileEntryException {
        DLFileEntry dlFileEntry = DLFileEntryUtil.findByG_F_T((long)repositoryId, (long)folderId, (String)title);
        return new LiferayFileEntry(dlFileEntry);
    }

    public static InputStream getContentStream(FileEntry fileEntry) throws PortalException {
        long repositoryId = DLFolderConstants.getDataRepositoryId((long)fileEntry.getRepositoryId(), (long)fileEntry.getFolderId());
        String name = ((DLFileEntry)fileEntry.getModel()).getName();
        InputStream is = DLStoreUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)repositoryId, (String)name, (String)fileEntry.getVersion());
        if (is == null) {
            is = new UnsyncByteArrayInputStream(new byte[0]);
        }
        return is;
    }
}

