/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GitUtil {
    public static List<String> getCurrentBranchFileNames(String baseDirName, String gitWorkingBranchName) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git merge-base HEAD " + gitWorkingBranchName);
        String mergeBaseCommitId = unsyncBufferedReader.readLine();
        return GitUtil.getFileNames(baseDirName, mergeBaseCommitId);
    }

    public static List<String> getLatestAuthorFileNames(String baseDirName) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git log");
        String line = null;
        String firstDifferentAuthorCommitId = null;
        String latestAuthor = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("commit ")) {
                firstDifferentAuthorCommitId = line.substring(7);
                continue;
            }
            if (!line.startsWith("Author: ")) continue;
            if (latestAuthor == null) {
                int x = line.lastIndexOf(60);
                int y = line.lastIndexOf(62);
                latestAuthor = line.substring(x + 1, y);
                continue;
            }
            if (line.endsWith("<" + latestAuthor + ">")) continue;
            break;
        }
        return GitUtil.getFileNames(baseDirName, firstDifferentAuthorCommitId);
    }

    public static List<String> getLocalChangesFileNames(String baseDirName) throws Exception {
        ArrayList<String> localChangesFileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git add . --dry-run");
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.startsWith("add '") || StringUtil.count(line, '/') < gitLevel) continue;
            String fileName = GitUtil.getFileName(line.substring(5, line.length() - 1), gitLevel);
            localChangesFileNames.add(fileName);
        }
        return localChangesFileNames;
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String baseDirName = ArgumentsUtil.getString(arguments, "git.base.dir", "./");
        String markerFileName = ArgumentsUtil.getString(arguments, "git.marker.file", null);
        String type = ArgumentsUtil.getString(arguments, "git.type", "current-branch");
        try {
            Collection<String> fileNames = null;
            if (type.equals("current-branch")) {
                String gitWorkingBranchName = ArgumentsUtil.getString(arguments, "git.working.branch.name", "master");
                fileNames = GitUtil.getCurrentBranchFileNames(baseDirName, gitWorkingBranchName);
            } else if (type.equals("latest-author")) {
                fileNames = GitUtil.getLatestAuthorFileNames(baseDirName);
            } else if (type.equals("local-changes")) {
                fileNames = GitUtil.getLocalChangesFileNames(baseDirName);
            } else {
                throw new IllegalArgumentException();
            }
            if (Validator.isNotNull(markerFileName)) {
                fileNames = GitUtil.getDirNames(baseDirName, fileNames, markerFileName);
            }
            for (String fileName : fileNames) {
                System.out.println(fileName);
            }
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    protected static Set<String> getDirNames(String baseDirName, Iterable<String> fileNames, String markerFileName) {
        File baseDir = new File(baseDirName);
        Path baseDirPath = baseDir.toPath();
        HashSet<String> dirNames = new HashSet<String>();
        for (String fileName : fileNames) {
            File file = new File(baseDir, fileName);
            File dir = GitUtil.getRootDir(file.getParentFile(), baseDir, markerFileName);
            if (dir == null) continue;
            String dirName = String.valueOf(baseDirPath.relativize(dir.toPath()));
            dirName = StringUtil.replace(dirName, File.separatorChar, '/');
            dirNames.add(dirName);
        }
        return dirNames;
    }

    protected static String getFileName(String fileName, int gitLevel) {
        for (int i = 0; i < gitLevel; ++i) {
            int x = fileName.indexOf("/");
            fileName = fileName.substring(x + 1);
        }
        return fileName;
    }

    protected static List<String> getFileNames(String baseDirName, String commitId) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git diff --diff-filter=AM --name-only " + commitId);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.count(line, '/') < gitLevel) continue;
            fileNames.add(GitUtil.getFileName(line, gitLevel));
        }
        return fileNames;
    }

    protected static UnsyncBufferedReader getGitCommandReader(String gitCommand) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(gitCommand);
        }
        catch (IOException ioe) {
            String errorMessage = ioe.getMessage();
            if (errorMessage.contains("Cannot run program")) {
                throw new GitException("Add Git to your PATH system variable first.");
            }
            throw ioe;
        }
        return new UnsyncBufferedReader(new InputStreamReader(process.getInputStream()));
    }

    protected static int getGitLevel(String baseDirName) throws GitException {
        for (int i = 0; i < 7; ++i) {
            File file = new File(baseDirName + ".git");
            if (file.exists()) {
                return i;
            }
            baseDirName = "../" + baseDirName;
        }
        throw new GitException("Unable to retrieve files because .git directory is missing.");
    }

    protected static File getRootDir(File dir, File baseDir, String markerFileName) {
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null && !baseDir.equals(dir));
        return null;
    }
}

