/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.configuration.SourceChecksResult;
import com.liferay.source.formatter.checks.configuration.SourceChecksSuppressions;
import com.liferay.source.formatter.checks.configuration.SuppressionsLoader;
import com.liferay.source.formatter.checks.util.SourceChecksUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    protected static boolean portalSource;
    protected static boolean subrepository;
    protected SourceFormatterArgs sourceFormatterArgs;
    private static final int _SUBREPOSITORY_MAX_DIR_LEVEL = 3;
    private List<String> _allFileNames;
    private boolean _browserStarted;
    private SourceMismatchException _firstSourceMismatchException;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private BlockingQueue<ProgressStatusUpdate> _progressStatusQueue;
    private Map<String, Properties> _propertiesMap;
    private List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private SourceChecksSuppressions _sourceChecksSuppressions;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();

    @Override
    public final void format() throws Exception {
        List<String> fileNames = this.getFileNames();
        if (this.sourceFormatterArgs.isShowDebugInformation()) {
            Class<?> clazz = this.getClass();
            DebugUtil.addProcessorFileCount(clazz.getSimpleName(), fileNames.size());
        }
        if (fileNames.isEmpty()) {
            this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.SOURCE_CHECKS_INITIALIZED, 0));
            return;
        }
        this._pluginsInsideModulesDirectoryNames = this.getPluginsInsideModulesDirectoryNames();
        this._sourceChecks = this._getSourceChecks(this._containsModuleFile(fileNames));
        this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.SOURCE_CHECKS_INITIALIZED, fileNames.size()));
        this._sourceChecksSuppressions = SuppressionsLoader.loadSuppressions(this.getSuppressionsFiles("sourcechecks-suppressions.xml"));
        ExecutorService executorService = Executors.newFixedThreadPool(this.sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        BaseSourceProcessor.this._format(string);
                        return null;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unable to format " + string, t);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return fileNames;
        }
        return this.doGetFileNames();
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    public void setProgressStatusQueue(BlockingQueue<ProgressStatusUpdate> progressStatusQueue) {
        this._progressStatusQueue = progressStatusQueue;
    }

    @Override
    public void setPropertiesMap(Map<String, Properties> propertiesMap) {
        this._propertiesMap = propertiesMap;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
        this._init();
    }

    @Override
    public void setSourceFormatterExcludes(SourceFormatterExcludes sourceFormatterExcludes) {
        this._sourceFormatterExcludes = sourceFormatterExcludes;
    }

    protected void addProgressStatusUpdate(ProgressStatusUpdate progressStatusUpdate) throws Exception {
        this._progressStatusQueue.put(progressStatusUpdate);
    }

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this.sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this.sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(excludes, includes, false);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes, boolean forceIncludeAllFiles) throws Exception {
        if (!forceIncludeAllFiles && this.sourceFormatterArgs.getRecentChangesFileNames() != null) {
            return SourceFormatterUtil.filterRecentChangesFileNames(this.sourceFormatterArgs.getBaseDirName(), this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes, this._sourceFormatterExcludes, this.sourceFormatterArgs.isIncludeSubrepositories());
        }
        return SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, includes, this._sourceFormatterExcludes, forceIncludeAllFiles);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() throws Exception {
        if (this._pluginsInsideModulesDirectoryNames != null) {
            return this._pluginsInsideModulesDirectoryNames;
        }
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = this.getFileNames(new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/private/apps/**/build.xml"}, true);
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = SourceUtil.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, '\\', '/'));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        return pluginsInsideModulesDirectoryNames;
    }

    protected BlockingQueue<ProgressStatusUpdate> getProgressStatusQueue() {
        return this._progressStatusQueue;
    }

    protected List<File> getSuppressionsFiles(String fileName) throws Exception {
        ArrayList<File> suppressionsFiles = new ArrayList<File>();
        int maxDirLevel = 3;
        String parentDirName = this.sourceFormatterArgs.getBaseDirName();
        if (portalSource || subrepository) {
            maxDirLevel = 7;
        }
        for (int i = 0; i < maxDirLevel; ++i) {
            File suppressionsFile = new File(parentDirName + fileName);
            if (suppressionsFile.exists()) {
                suppressionsFiles.add(suppressionsFile);
            }
            parentDirName = parentDirName + "../";
        }
        if (!portalSource && !subrepository) {
            return suppressionsFiles;
        }
        List<String> moduleSuppressionsFileNames = this.getFileNames(new String[0], new String[]{"**/" + fileName}, true);
        for (String moduleSuppressionsFileName : moduleSuppressionsFileNames) {
            moduleSuppressionsFileName = StringUtil.replace(moduleSuppressionsFileName, '\\', '/');
            suppressionsFiles.add(new File(moduleSuppressionsFileName));
        }
        return suppressionsFiles;
    }

    protected void postFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this.sourceFormatterArgs.isPrintErrors()) {
            SourceFormatterUtil.printError(fileName, message);
        }
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws Exception {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this.sourceFormatterArgs.isPrintErrors()) {
                SourceFormatterUtil.printError(fileName, file);
            }
            if (this.sourceFormatterArgs.isAutoFix()) {
                FileUtil.write(file, newContent);
            } else if (this._firstSourceMismatchException == null) {
                this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
            }
        }
        if (this.sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                String markdownFilePath;
                SourceFormatterUtil.printError(fileName, sourceFormatterMessage.toString());
                if (this._browserStarted || !this.sourceFormatterArgs.isShowDocumentation() || !Desktop.isDesktopSupported() || !Validator.isNotNull(markdownFilePath = sourceFormatterMessage.getMarkdownFilePath())) continue;
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(markdownFilePath));
                this._browserStarted = true;
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
    }

    protected void processMessage(String fileName, SourceFormatterMessage sourceFormatterMessage) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(sourceFormatterMessage);
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void processMessage(String fileName, String message) {
        this.processMessage(fileName, new SourceFormatterMessage(fileName, message, null, -1));
    }

    protected String processSourceChecks(File file, String fileName, String absolutePath, String content) throws Exception {
        SourceChecksResult sourceChecksResult = SourceChecksUtil.processSourceChecks(file, fileName, absolutePath, content, this._isModulesFile(absolutePath), this._sourceChecks, this._sourceChecksSuppressions, this.sourceFormatterArgs.isShowDebugInformation());
        for (SourceFormatterMessage sourceFormatterMessage : sourceChecksResult.getSourceFormatterMessages()) {
            this.processMessage(fileName, sourceFormatterMessage);
        }
        return sourceChecksResult.getContent();
    }

    private void _checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            this.processMessage(fileName, "UTF-8");
        }
    }

    private boolean _containsModuleFile(List<String> fileNames) {
        for (String fileName : fileNames) {
            String absolutePath;
            if (!this._isMatchPath(fileName) || !this._isModulesFile(absolutePath = SourceUtil.getAbsolutePath(fileName), true)) continue;
            return true;
        }
        return false;
    }

    private final String _format(File file, String fileName, String absolutePath, String content, String originalContent, Set<String> modifiedContents, int count) throws Exception {
        this._sourceFormatterMessagesMap.remove(fileName);
        this._checkUTF8(file, fileName);
        String newContent = this.processSourceChecks(file, fileName, absolutePath, content);
        if (content.equals(newContent)) {
            return content;
        }
        if (!modifiedContents.add(newContent)) {
            this.processMessage(fileName, "Infinite loop in SourceFormatter");
            return originalContent;
        }
        if (newContent.length() > content.length()) {
            if (++count > 100) {
                this.processMessage(fileName, "Infinite loop in SourceFormatter");
                return originalContent;
            }
        } else {
            count = 0;
        }
        return this._format(file, fileName, absolutePath, newContent, originalContent, modifiedContents, count);
    }

    private final void _format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.SOURCE_CHECK_FILE_COMPLETED));
            return;
        }
        fileName = StringUtil.replace(fileName, '\\', '/');
        String absolutePath = SourceUtil.getAbsolutePath(fileName);
        File file = new File(absolutePath);
        String content = FileUtil.read(file);
        HashSet<String> modifiedContents = new HashSet<String>();
        String newContent = this._format(file, fileName, absolutePath, content, content, modifiedContents, 0);
        this.processFormattedFile(file, fileName, content, newContent);
        this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.SOURCE_CHECK_FILE_COMPLETED));
    }

    private List<SourceCheck> _getSourceChecks(boolean includeModuleChecks) throws Exception {
        Class<?> clazz = this.getClass();
        List<SourceCheck> sourceChecks = SourceChecksUtil.getSourceChecks(clazz.getSimpleName(), portalSource, subrepository, includeModuleChecks);
        for (SourceCheck sourceCheck : sourceChecks) {
            this._initSourceCheck(sourceCheck);
        }
        return sourceChecks;
    }

    private void _init() {
        try {
            portalSource = this._isPortalSource();
            subrepository = this._isSubrepository();
            this._sourceFormatterMessagesMap = new HashMap<String, Set<SourceFormatterMessage>>();
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
    }

    private void _initSourceCheck(SourceCheck sourceCheck) throws Exception {
        sourceCheck.setAllFileNames(this._allFileNames);
        sourceCheck.setBaseDirName(this.sourceFormatterArgs.getBaseDirName());
        sourceCheck.setMaxLineLength(this.sourceFormatterArgs.getMaxLineLength());
        sourceCheck.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceCheck.setPortalSource(portalSource);
        sourceCheck.setPropertiesMap(this._propertiesMap);
        sourceCheck.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceCheck.setSubrepository(subrepository);
        sourceCheck.init();
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isModulesFile(String absolutePath) {
        return this._isModulesFile(absolutePath, false);
    }

    private boolean _isModulesFile(String absolutePath, boolean includePlugins) {
        if (subrepository) {
            return true;
        }
        if (includePlugins) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 7) != null;
    }

    private boolean _isSubrepository() {
        String baseDirAbsolutePath = SourceUtil.getAbsolutePath(this.sourceFormatterArgs.getBaseDirName());
        int x = baseDirAbsolutePath.length();
        for (int i = 0; i < 3; ++i) {
            if ((x = baseDirAbsolutePath.lastIndexOf(47, x - 1)) == -1) {
                return false;
            }
            String dirName = baseDirAbsolutePath.substring(x + 1);
            if (!dirName.startsWith("com-liferay-")) continue;
            return true;
        }
        return false;
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }
}

