/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDImportsFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDImportsCheck
extends BaseFileCheck {
    private final Pattern _conditionalPackagePattern = Pattern.compile("\n-conditionalpackage:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _importsPattern = Pattern.compile("\nImport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _internalPrivatePackagePattern = Pattern.compile("(,\\\\\n\t|: )(.*\\.internal.*)(\n|\\Z)");
    private final Pattern _privatePackagesPattern = Pattern.compile("\nPrivate-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _wilcardImportPattern = Pattern.compile("(\\S+\\*)(,\\\\\n|\n|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        this._checkWildcardImports(fileName, absolutePath, content, this._conditionalPackagePattern);
        this._checkWildcardImports(fileName, absolutePath, content, this._exportContentsPattern);
        this._checkWildcardImports(fileName, absolutePath, content, this._exportsPattern);
        BNDImportsFormatter importsFormatter = new BNDImportsFormatter();
        content = importsFormatter.format(content, this._conditionalPackagePattern);
        content = importsFormatter.format(content, this._exportContentsPattern);
        content = importsFormatter.format(content, this._exportsPattern);
        content = importsFormatter.format(content, this._importsPattern);
        content = importsFormatter.format(content, this._privatePackagesPattern);
        if (!absolutePath.contains("-test/")) {
            content = this._removeInternalPrivatePackages(content);
        }
        return content;
    }

    private void _checkWildcardImports(String fileName, String absolutePath, String content, Pattern pattern) {
        if (absolutePath.contains("/portal-kernel/") || absolutePath.contains("/third-party/") || absolutePath.contains("/util-bridges/") || absolutePath.contains("/util-java/") || absolutePath.contains("/util-taglib/") || fileName.endsWith("/system.packages.extra.bnd")) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String imports = matcher.group(3);
        matcher = this._wilcardImportPattern.matcher(imports);
        while (matcher.find()) {
            String wildcardImport = matcher.group(1);
            if (!wildcardImport.matches("^!?com\\.liferay\\..+")) continue;
            this.addMessage(fileName, "Do not use wildcard in Export-Package '" + wildcardImport + "'");
        }
    }

    private String _removeInternalPrivatePackages(String content) {
        Matcher matcher = this._privatePackagesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        if (!(matcher = this._internalPrivatePackagePattern.matcher(match)).find()) {
            return content;
        }
        String replacement = StringUtil.removeSubstring(match, matcher.group(2));
        return StringUtil.replace(content, match, replacement);
    }
}

