/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONPropertyOrderCheck
extends BaseFileCheck {
    private final Pattern _incorrectLineBreakPattern = Pattern.compile("\t[\\}\\]]{2}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._incorrectLineBreakPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '}'", this.getLineCount(content, matcher.start()));
            return content;
        }
        return this._sortProperties(content);
    }

    private String _sortProperties(String content) {
        Pattern pattern1;
        Matcher matcher1;
        String tabs = "";
        while ((matcher1 = (pattern1 = Pattern.compile("(\n|^)" + tabs + "[^\n\t]*[\\{\\[]\n")).matcher(content)).find()) {
            Pattern pattern2 = Pattern.compile("((\n|^)" + tabs + "[^\n\t]*\\{\n" + tabs + "\t[^\n\t][\\s\\S]*?)\n" + tabs + "\\}");
            Matcher matcher2 = pattern2.matcher(content);
            while (matcher2.find()) {
                Pattern pattern3 = Pattern.compile("(" + tabs + "\t[^\n\t]*?([^\\{\\[]|([\\{\\[]\n[\\s\\S]*?\n" + tabs + "\t[\\}\\]]))),?(\n|$)");
                String match = matcher2.group(1);
                Matcher matcher3 = pattern3.matcher(match);
                String previousProperty = null;
                while (matcher3.find()) {
                    String property = "\n" + matcher3.group(1);
                    if (Validator.isNotNull(previousProperty) && previousProperty.compareTo(property) > 0) {
                        String replacement = StringUtil.replaceFirst(match, previousProperty, property);
                        replacement = StringUtil.replaceLast(replacement, property, previousProperty);
                        return StringUtil.replace(content, match, replacement);
                    }
                    previousProperty = property;
                }
            }
            tabs = tabs + "\t";
        }
        return content;
    }
}

