/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaPackagePathCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (Validator.isNull(packagePath)) {
            this.addMessage(fileName, "Missing package");
            return content;
        }
        this._checkPackagePath(fileName, packagePath);
        if (!absolutePath.contains("/modules/private/apps/") && this.isModulesFile(absolutePath)) {
            this._checkModulePackagePath(fileName, packagePath);
        }
        return content;
    }

    private void _checkModulePackagePath(String fileName, String packagePath) throws Exception {
        if (!packagePath.startsWith("com.liferay")) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.startsWith("com.liferay")) {
            return;
        }
        if (packagePath.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|service|test)$", ""))) {
            return;
        }
        if (!packagePath.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.impl$", ".internal"))) {
            this.addMessage(fileName, "Package should follow Bundle-SymbolicName specified in " + bndSettings.getFileName(), "package.markdown");
        }
    }

    private void _checkPackagePath(String fileName, String packagePath) {
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packagePath)) {
            this.addMessage(fileName, "The declared package '" + packagePath + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packagePath.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use 'impl' inside 'internal', see LPS-70113");
        }
    }
}

